/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.ml.spark.ml.recommendation.als;

import com.datastax.insight.spec.DataSetOperator;
import com.google.common.base.Strings;
import org.apache.spark.ml.recommendation.ALS;
import org.apache.spark.ml.recommendation.ALSModel;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class ALSWrapper
implements DataSetOperator {
    public static ALS getOperator(String userCol, String itemCol, String ratingCol, Integer rank, Integer numUserBlocks, Integer numItemBlocks, Boolean implicitPrefs, Double alpha, Integer maxIterations, Double regParam, Boolean nonnegative, Integer checkpointInterval, Long seed, String intermediateStorageLevel, String finalStorageLevel) {
        ALS als = new ALS();
        if (!Strings.isNullOrEmpty((String)userCol)) {
            als.setUserCol(userCol);
        }
        if (!Strings.isNullOrEmpty((String)itemCol)) {
            als.setItemCol(itemCol);
        }
        if (!Strings.isNullOrEmpty((String)ratingCol)) {
            als.setRatingCol(ratingCol);
        }
        if (rank != null) {
            als.setRank(rank.intValue());
        }
        if (numUserBlocks != null) {
            als.setNumBlocks(numUserBlocks.intValue());
        }
        if (numItemBlocks != null) {
            als.setNumItemBlocks(numItemBlocks.intValue());
        }
        if (implicitPrefs != null) {
            als.setImplicitPrefs(implicitPrefs.booleanValue());
        }
        if (alpha != null) {
            als.setAlpha(alpha.doubleValue());
        }
        if (maxIterations != null) {
            als.setMaxIter(maxIterations.intValue());
        }
        if (regParam != null) {
            als.setRegParam(regParam.doubleValue());
        }
        if (nonnegative != null) {
            als.setNonnegative(nonnegative.booleanValue());
        }
        if (checkpointInterval != null) {
            als.setCheckpointInterval(checkpointInterval.intValue());
        }
        if (seed != null) {
            als.setSeed(seed.longValue());
        }
        if (!Strings.isNullOrEmpty((String)intermediateStorageLevel)) {
            als.setIntermediateStorageLevel(intermediateStorageLevel);
        }
        if (!Strings.isNullOrEmpty((String)finalStorageLevel)) {
            als.setFinalStorageLevel(finalStorageLevel);
        }
        return als;
    }

    public static ALSModel fit(Dataset<Row> data, String userCol, String itemCol, String ratingCol, int rank, int numUserBlocks, int numItemBlocks, boolean implicitPrefs, double alpha, int maxIterations, double regParam, boolean nonnegative, int checkpointInterval, long seed, String intermediateStorageLevel, String finalStorageLevel) {
        ALS als = ALSWrapper.getOperator(userCol, itemCol, ratingCol, rank, numUserBlocks, numItemBlocks, implicitPrefs, alpha, maxIterations, regParam, nonnegative, checkpointInterval, seed, intermediateStorageLevel, finalStorageLevel);
        ALSModel model = als.fit(data);
        return model;
    }

    public static ALSModel fit(ALS als, Dataset<Row> data) {
        ALSModel model = als.fit(data);
        return model;
    }

    public static Dataset<Row> transform(ALSModel model, Dataset<Row> data) {
        Dataset predictions = model.transform(data);
        return predictions;
    }
}

