/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.ml.spark.ml.recommendation.als;

import com.datastax.insight.ml.spark.data.dataset.DataSetLoader;
import com.datastax.insight.ml.spark.ml.recommendation.als.Rating;
import com.datastax.insight.spec.DataSetOperator;
import com.google.common.base.Strings;
import java.io.Serializable;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders$;

public class RatingLoader
implements DataSetOperator {
    private static final String DELIMITER = "::";
    private static final String[] f = new String[]{"user", "product", "rating", "timestamp"};

    public static Dataset<Rating> fromTextFile(String type, String path, String delimiter, String propList) {
        String[] propOrders = null;
        if (propList != null) {
            propOrders = propList.split(",");
        }
        Integer[] orders = new Integer[f.length];
        block0: for (int i2 = 0; i2 < f.length; ++i2) {
            for (int j2 = 0; j2 < propOrders.length; ++j2) {
                if (!f[i2].equals(propOrders[j2])) continue;
                orders[i2] = j2;
                continue block0;
            }
        }
        if (Strings.isNullOrEmpty((String)delimiter)) {
            String finalDelimiter = DELIMITER;
        } else {
            String finalDelimiter = delimiter;
        }
        return DataSetLoader.file(type, path).map((MapFunction & Serializable)row -> {
            int user = Integer.parseInt(row.getString(orders[0].intValue()));
            int product = Integer.parseInt(row.getString(orders[1].intValue()));
            float rating = Float.parseFloat(row.getString(orders[2].intValue()));
            if (row.size() == 3) {
                return new Rating(user, product, rating);
            }
            long timestamp = Long.parseLong(row.getString(orders[3].intValue()));
            return new Rating(user, product, rating, timestamp);
        }, Encoders$.MODULE$.bean(Rating.class));
    }
}

