/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.ml.spark.ml.regression;

import com.datastax.insight.spec.DataSetOperator;
import com.google.common.base.Strings;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel;
import org.apache.spark.ml.regression.DecisionTreeRegressor;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class DecisionTreeRegressionWrapper
implements DataSetOperator {
    public static DecisionTreeRegressor getOperator(String labelCol, String featuresCol, Integer maxDepth, Integer maxBins, Integer minInstancesPerNode, Double minInfoGain, Integer maxMemoryInMB, Boolean cacheNodeIds, Integer checkpointInterval, String impurity, String varianceCol) {
        DecisionTreeRegressor regressor = new DecisionTreeRegressor();
        if (!Strings.isNullOrEmpty((String)labelCol)) {
            regressor.setLabelCol(labelCol);
        }
        if (!Strings.isNullOrEmpty((String)impurity)) {
            regressor.setFeaturesCol(featuresCol);
        }
        if (maxDepth != null) {
            regressor.setMaxDepth(maxDepth.intValue());
        }
        if (maxBins != null) {
            regressor.setMaxBins(maxBins.intValue());
        }
        if (minInstancesPerNode != null) {
            regressor.setMinInstancesPerNode(minInstancesPerNode.intValue());
        }
        if (minInfoGain != null) {
            regressor.setMinInfoGain(minInfoGain.doubleValue());
        }
        if (maxMemoryInMB != null) {
            regressor.setMaxMemoryInMB(maxMemoryInMB.intValue());
        }
        if (cacheNodeIds != null) {
            regressor.setCacheNodeIds(cacheNodeIds.booleanValue());
        }
        if (checkpointInterval != null) {
            regressor.setCheckpointInterval(checkpointInterval.intValue());
        }
        if (!Strings.isNullOrEmpty((String)impurity)) {
            regressor.setImpurity(impurity);
        }
        if (!Strings.isNullOrEmpty((String)varianceCol)) {
            regressor.setVarianceCol(varianceCol);
        }
        return regressor;
    }

    public static DecisionTreeRegressionModel fit(Dataset<Row> data, String labelCol, String featuresCol, Integer maxDepth, Integer maxBins, Integer minInstancesPerNode, Double minInfoGain, Integer maxMemoryInMB, Boolean cacheNodeIds, Integer checkpointInterval, String impurity, String varianceCol) {
        DecisionTreeRegressor regressor = DecisionTreeRegressionWrapper.getOperator(labelCol, featuresCol, maxDepth, maxBins, minInstancesPerNode, minInfoGain, maxMemoryInMB, cacheNodeIds, checkpointInterval, impurity, varianceCol);
        return (DecisionTreeRegressionModel)regressor.fit(data);
    }

    public static DecisionTreeRegressionModel fit(DecisionTreeRegressor regressor, Dataset<Row> data) {
        return (DecisionTreeRegressionModel)regressor.fit(data);
    }

    public static Dataset<Row> transform(DecisionTreeRegressionModel model, Dataset<Row> data) {
        return model.transform(data);
    }
}

