/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.ml.spark.ml.regression;

import com.datastax.insight.spec.DataSetOperator;
import com.google.common.base.Strings;
import org.apache.spark.ml.regression.GeneralizedLinearRegression;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionModel;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class GeneralizedLinearRegressionWrapper
implements DataSetOperator {
    public static GeneralizedLinearRegression getOperator(String labelCol, String featuresCol, String family, String link, Integer maxIterations, Double regParam, Double tol, Boolean fitIntercept, String weightCol, String solver, String linkPredictionCol) {
        GeneralizedLinearRegression regressor = new GeneralizedLinearRegression();
        if (!Strings.isNullOrEmpty((String)featuresCol)) {
            regressor.setFeaturesCol(featuresCol);
        }
        if (!Strings.isNullOrEmpty((String)labelCol)) {
            regressor.setLabelCol(labelCol);
        }
        if (!Strings.isNullOrEmpty((String)family)) {
            regressor.setFamily(family);
        }
        if (!Strings.isNullOrEmpty((String)link)) {
            regressor.setLink(link);
        }
        if (maxIterations != null) {
            regressor.setMaxIter(maxIterations.intValue());
        }
        if (regParam != null) {
            regressor.setRegParam(regParam.doubleValue());
        }
        if (tol != null) {
            regressor.setTol(tol.doubleValue());
        }
        if (fitIntercept != null) {
            regressor.setFitIntercept(fitIntercept.booleanValue());
        }
        if (!Strings.isNullOrEmpty((String)weightCol)) {
            regressor.setWeightCol(weightCol);
        }
        if (!Strings.isNullOrEmpty((String)solver)) {
            regressor.setSolver(solver);
        }
        if (!Strings.isNullOrEmpty((String)linkPredictionCol)) {
            regressor.setLinkPredictionCol(linkPredictionCol);
        }
        return regressor;
    }

    public static GeneralizedLinearRegressionModel fit(Dataset<Row> data, String labelCol, String featuresCol, String family, String link, Integer maxIterations, Double regParam, Double tol, Boolean fitIntercept, String weightCol, String solver, String linkPredictionCol) {
        GeneralizedLinearRegression regressor = GeneralizedLinearRegressionWrapper.getOperator(labelCol, featuresCol, family, link, maxIterations, regParam, tol, fitIntercept, weightCol, solver, linkPredictionCol);
        return (GeneralizedLinearRegressionModel)regressor.fit(data);
    }

    public static GeneralizedLinearRegressionModel fit(GeneralizedLinearRegression regressor, Dataset<Row> data) {
        return (GeneralizedLinearRegressionModel)regressor.fit(data);
    }

    public static Dataset<Row> transform(GeneralizedLinearRegressionModel model, Dataset<Row> data) {
        return model.transform(data);
    }
}

