/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.ml.spark.ml.regression;

import com.datastax.insight.spec.DataSetOperator;
import com.google.common.base.Strings;
import org.apache.spark.ml.regression.GBTRegressionModel;
import org.apache.spark.ml.regression.GBTRegressor;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class GradientBoostedTreeRegressor
implements DataSetOperator {
    public static GBTRegressor getOperator(String labelCol, String featuresCol, Integer maxIterations, Integer maxDepth, Integer maxBins, Integer minInstancesPerNode, Double minInfoGain, Integer maxMemoryInMB, Boolean cacheNodeIds, Integer checkpointInterval, String impurity, Double subsamplingRate, Long seed, Double stepSize, String lossType) {
        GBTRegressor regressor = new GBTRegressor();
        if (!Strings.isNullOrEmpty((String)labelCol)) {
            regressor.setLabelCol(labelCol);
        }
        if (!Strings.isNullOrEmpty((String)featuresCol)) {
            regressor.setFeaturesCol(featuresCol);
        }
        if (maxIterations != null) {
            regressor.setMaxIter(maxIterations.intValue());
        }
        if (maxDepth != null) {
            regressor.setMaxDepth(maxDepth.intValue());
        }
        if (maxBins != null) {
            regressor.setMaxBins(maxBins.intValue());
        }
        if (minInstancesPerNode != null) {
            regressor.setMinInstancesPerNode(minInstancesPerNode.intValue());
        }
        if (minInfoGain != null) {
            regressor.setMinInfoGain(minInfoGain.doubleValue());
        }
        if (maxMemoryInMB != null) {
            regressor.setMaxMemoryInMB(maxMemoryInMB.intValue());
        }
        if (cacheNodeIds != null) {
            regressor.setCacheNodeIds(cacheNodeIds.booleanValue());
        }
        if (checkpointInterval != null) {
            regressor.setCheckpointInterval(checkpointInterval.intValue());
        }
        if (!Strings.isNullOrEmpty((String)impurity)) {
            regressor.setImpurity(impurity);
        }
        if (subsamplingRate != null) {
            regressor.setSubsamplingRate(subsamplingRate.doubleValue());
        }
        if (seed != null) {
            regressor.setSeed(seed.longValue());
        }
        if (stepSize != null) {
            regressor.setStepSize(stepSize.doubleValue());
        }
        if (!Strings.isNullOrEmpty((String)lossType)) {
            regressor.setLossType(lossType);
        }
        return regressor;
    }

    public static GBTRegressionModel fit(Dataset<Row> data, String labelCol, String featuresCol, Integer maxIterations, Integer maxDepth, Integer maxBins, Integer minInstancesPerNode, Double minInfoGain, Integer maxMemoryInMB, Boolean cacheNodeIds, Integer checkpointInterval, String impurity, Double subsamplingRate, Long seed, Double stepSize, String lossType) {
        GBTRegressor regressor = GradientBoostedTreeRegressor.getOperator(labelCol, featuresCol, maxIterations, maxDepth, maxBins, minInstancesPerNode, minInfoGain, maxMemoryInMB, cacheNodeIds, checkpointInterval, impurity, subsamplingRate, seed, stepSize, lossType);
        return (GBTRegressionModel)regressor.fit(data);
    }

    public static GBTRegressionModel fit(GBTRegressor regressor, Dataset<Row> data) {
        return (GBTRegressionModel)regressor.fit(data);
    }

    public static Dataset<Row> transform(GBTRegressionModel model, Dataset<Row> data) {
        return model.transform(data);
    }
}

