/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.ml.spark.ml.regression;

import com.datastax.insight.spec.DataSetOperator;
import com.google.common.base.Strings;
import org.apache.spark.ml.regression.LinearRegression;
import org.apache.spark.ml.regression.LinearRegressionModel;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class LinearRegressionWrapper
implements DataSetOperator {
    public static LinearRegression getOperator(Integer maxIterations, Double regParam, Double elasticNetParam, Double tol, Boolean fitIntercept, Boolean standardization, String weightCol, String solver, String featuresCol, String labelCol, String predictionCol) {
        LinearRegression regressor = new LinearRegression();
        if (maxIterations != null) {
            regressor.setMaxIter(maxIterations.intValue());
        }
        if (regParam != null) {
            regressor.setRegParam(regParam.doubleValue());
        }
        if (elasticNetParam != null) {
            regressor.setElasticNetParam(elasticNetParam.doubleValue());
        }
        if (tol != null) {
            regressor.setTol(tol.doubleValue());
        }
        if (fitIntercept != null) {
            regressor.setFitIntercept(fitIntercept.booleanValue());
        }
        if (standardization != null) {
            regressor.setStandardization(standardization.booleanValue());
        }
        if (!Strings.isNullOrEmpty((String)weightCol)) {
            regressor.setWeightCol(weightCol);
        }
        if (!Strings.isNullOrEmpty((String)solver)) {
            regressor.setSolver(solver);
        }
        if (!Strings.isNullOrEmpty((String)featuresCol)) {
            regressor.setFeaturesCol(featuresCol);
        }
        if (!Strings.isNullOrEmpty((String)labelCol)) {
            regressor.setLabelCol(labelCol);
        }
        if (!Strings.isNullOrEmpty((String)predictionCol)) {
            regressor.setPredictionCol(predictionCol);
        }
        return regressor;
    }

    public static LinearRegressionModel fit(Dataset<Row> data, Integer maxIterations, Double regParam, Double elasticNetParam, Double tol, Boolean fitIntercept, Boolean standardization, String weightCol, String solver, String featuresCol, String labelCol, String predictionCol) {
        LinearRegression regressor = LinearRegressionWrapper.getOperator(maxIterations, regParam, elasticNetParam, tol, fitIntercept, standardization, weightCol, solver, featuresCol, labelCol, predictionCol);
        return (LinearRegressionModel)regressor.fit(data);
    }

    public static LinearRegressionModel fit(LinearRegression regressor, Dataset<Row> data) {
        return (LinearRegressionModel)regressor.fit(data);
    }

    public Dataset<Row> transform(LinearRegressionModel model, Dataset<Row> data) {
        return model.transform(data);
    }
}

