/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.ml.spark.ml.regression;

import com.datastax.insight.spec.DataSetOperator;
import com.google.common.base.Strings;
import org.apache.spark.ml.regression.AFTSurvivalRegression;
import org.apache.spark.ml.regression.AFTSurvivalRegressionModel;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class SurvivalRegressionWrapper
implements DataSetOperator {
    public static AFTSurvivalRegression getOperator(String labelCol, String censorCol, String predictionCol, String qp, String quantilesCol, Integer maxIterations, Double tol, Boolean fitIntercept) {
        AFTSurvivalRegression regressor = new AFTSurvivalRegression();
        if (!Strings.isNullOrEmpty((String)labelCol)) {
            regressor.setLabelCol(labelCol);
        }
        if (!Strings.isNullOrEmpty((String)censorCol)) {
            regressor.setCensorCol(censorCol);
        }
        if (!Strings.isNullOrEmpty((String)predictionCol)) {
            regressor.setPredictionCol(predictionCol);
        }
        if (!Strings.isNullOrEmpty((String)quantilesCol)) {
            regressor.setQuantilesCol(quantilesCol);
        }
        if (!Strings.isNullOrEmpty((String)qp)) {
            String[] qps = qp.split(";");
            double[] quantileProbabilities = new double[qps.length];
            for (int i2 = 0; i2 < quantileProbabilities.length; ++i2) {
                quantileProbabilities[i2] = Double.parseDouble(qps[i2]);
            }
            if (quantileProbabilities != null) {
                regressor.setQuantileProbabilities(quantileProbabilities);
            }
        }
        if (maxIterations != null) {
            regressor.setMaxIter(maxIterations.intValue());
        }
        if (tol != null) {
            regressor.setTol(tol.doubleValue());
        }
        if (fitIntercept != null) {
            regressor.setFitIntercept(fitIntercept.booleanValue());
        }
        return regressor;
    }

    public static AFTSurvivalRegressionModel fit(Dataset<Row> data, String labelCol, String censorCol, String predictionCol, String qp, String quantilesCol, Integer maxIterations, Double tol, Boolean fitIntercept) {
        AFTSurvivalRegression regressor = SurvivalRegressionWrapper.getOperator(labelCol, censorCol, predictionCol, qp, quantilesCol, maxIterations, tol, fitIntercept);
        return regressor.fit(data);
    }

    public static AFTSurvivalRegressionModel fit(AFTSurvivalRegression regressor, Dataset<Row> data) {
        return regressor.fit(data);
    }

    public Dataset<Row> transform(AFTSurvivalRegressionModel model, Dataset<Row> data) {
        return model.transform(data);
    }
}

