/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.ml.spark.ml.tuning;

import com.datastax.insight.spec.DataSetOperator;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.evaluation.Evaluator;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.tuning.CrossValidator;
import org.apache.spark.ml.tuning.CrossValidatorModel;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class CrossValidatorWrapper
implements DataSetOperator {
    public static CrossValidator getOperator(Estimator estimator, ParamMap[] estimatorParamMaps, Evaluator evaluator, Integer numFolds, Long seed) {
        CrossValidator validator = new CrossValidator();
        if (estimator != null) {
            validator.setEstimator(estimator);
        }
        if (estimatorParamMaps != null) {
            validator.setEstimatorParamMaps(estimatorParamMaps);
        }
        if (evaluator != null) {
            validator.setEvaluator(evaluator);
        }
        if (numFolds != null) {
            validator.setNumFolds(numFolds.intValue());
        }
        if (seed != null) {
            validator.setSeed(seed.longValue());
        }
        return validator;
    }

    public static CrossValidatorModel fit(Dataset<Row> data, CrossValidator validator) {
        return validator.fit(data);
    }

    public static CrossValidatorModel fit(Dataset<Row> data, Estimator estimator, ParamMap[] estimatorParamMaps, Evaluator evaluator, Integer numFolds, Long seed) {
        CrossValidator validator = CrossValidatorWrapper.getOperator(estimator, estimatorParamMaps, evaluator, numFolds, seed);
        return CrossValidatorWrapper.fit(data, validator);
    }

    public static Dataset<Row> transform(Dataset<Row> data, CrossValidatorModel model) {
        return model.transform(data);
    }
}

