/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.ml.spark.ml.tuning;

import com.datastax.insight.spec.DataSetOperator;
import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.FloatParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.tuning.ParamGridBuilder;

public class ParamGridBuilderWrapper
implements DataSetOperator {
    public static ParamMap[] getOperator(String args, Map<Object, String> params) {
        return ParamGridBuilderWrapper.getOperator(params);
    }

    public static ParamMap[] getOperator(Map<Object, String> params) {
        ParamGridBuilder builder = new ParamGridBuilder();
        params.keySet().forEach(key -> {
            String value = (String)params.get(key);
            if (Strings.isNullOrEmpty((String)value)) {
                if (key instanceof BooleanParam) {
                    builder.addGrid((BooleanParam)key);
                }
            } else {
                String[] values = value.split(";");
                if (key instanceof IntParam) {
                    int[] result = Arrays.stream(values).mapToInt(i2 -> Integer.parseInt(i2)).toArray();
                    builder.addGrid((IntParam)key, result);
                } else if (key instanceof FloatParam) {
                    Float[] result = (Float[])Arrays.stream(values).map(i2 -> Float.valueOf(Float.parseFloat(i2))).toArray(Float[]::new);
                    builder.addGrid((FloatParam)key, ArrayUtils.toPrimitive((Float[])result));
                } else if (key instanceof LongParam) {
                    long[] result = Arrays.stream(values).mapToLong(i2 -> Long.parseLong(i2)).toArray();
                    builder.addGrid((LongParam)key, result);
                } else if (key instanceof DoubleParam) {
                    double[] result = Arrays.stream(values).mapToDouble(i2 -> Double.parseDouble(i2)).toArray();
                    builder.addGrid((DoubleParam)key, result);
                }
            }
        });
        return builder.build();
    }
}

