/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.ml.spark.mllib.association;

import com.datastax.insight.spec.RDDOperator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.mllib.fpgrowth.a;
import org.apache.spark.mllib.fpm.AssociationRules;
import org.apache.spark.mllib.fpm.FPGrowth;
import org.apache.spark.mllib.fpm.FPGrowthModel;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.Tuple2;

public class FPGrowthEvaluator
implements RDDOperator {
    public static FPGrowthModel evaluate(JavaRDD<String> rdd, String delimiter, double minSupport, int numPartitions, double confidence) {
        JavaRDD data = rdd.map((Function & Serializable)line -> {
            String delim = delimiter;
            if (delim == null || delim.length() == 0) {
                delim = ";";
            }
            ArrayList list = new ArrayList();
            String[] items = line.split(delim);
            Collections.addAll(list, items);
            return list;
        });
        FPGrowthModel model = new FPGrowth().setMinSupport(minSupport).setNumPartitions(numPartitions).run(data);
        if (confidence > 0.0) {
            List rules = model.generateAssociationRules(confidence).toJavaRDD().collect();
            for (AssociationRules.Rule rule : rules) {
                System.out.println(rule.javaAntecedent() + "===>" + rule.javaConsequent() + "\uff0c" + rule.confidence());
            }
        }
        return model;
    }

    private static void a(RDD<FPGrowth.FreqItemset<String>> rdd) {
        List list = rdd.toJavaRDD().collect();
        for (FPGrowth.FreqItemset itemset : list) {
            System.out.println(itemset.javaItems() + "===>" + itemset.freq());
        }
    }

    public static <T> void fpgrowth(Dataset<T> data, String groupCol, String targetCol, double minSupport, int numPartitions, long minFreq, double p2, int minItems, String uri, String path) {
        a.fpgrowth((Dataset<Row>)data.toDF(), groupCol, targetCol, minSupport, numPartitions, minFreq, p2, minItems, uri, path);
    }

    private static RDD a(RDD rdd, Double p2, Integer minItems) {
        return a.a((RDD<Tuple2<String, Object[]>>)rdd, p2, minItems);
    }

    private static void a(RDD rdd, String uri, String path) {
        a.a((RDD<Tuple2<String, Object[]>>)rdd, uri, path);
    }
}

