/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.ml.spark.mllib.association;

import com.datastax.insight.spec.RDDOperator;
import java.util.ArrayList;
import java.util.List;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.mllib.fpm.PrefixSpan;
import org.apache.spark.mllib.fpm.PrefixSpanModel;

public class PrefixSpanEvaluator
implements RDDOperator {
    public static PrefixSpanModel<Integer> evaluate(JavaRDD<String> rdd, final String deliOne, final String deliTwo, double minSupport, int maxPatternLength) {
        JavaRDD sequences = rdd.map((Function)new Function<String, List<List<Integer>>>(){

            public List<List<Integer>> c(String line) throws Exception {
                String[] texts;
                ArrayList<List<Integer>> dataList = new ArrayList<List<Integer>>();
                for (String text : texts = line.split(deliOne)) {
                    String[] items;
                    ArrayList<Integer> list = new ArrayList<Integer>();
                    for (String item : items = text.split(deliTwo)) {
                        list.add(Integer.parseInt(item));
                    }
                    dataList.add(list);
                }
                return dataList;
            }

            public /* synthetic */ Object call(Object object) throws Exception {
                return this.c((String)object);
            }
        });
        return PrefixSpanEvaluator.evaluate((JavaRDD<List<List<Integer>>>)sequences, minSupport, maxPatternLength);
    }

    public static PrefixSpanModel<Integer> evaluate(JavaRDD<List<List<Integer>>> sequences, double minSupport, int maxPatternLength) {
        PrefixSpan prefixSpan = new PrefixSpan().setMinSupport(minSupport).setMaxPatternLength(maxPatternLength);
        PrefixSpanModel model = prefixSpan.run(sequences);
        return model;
    }
}

