/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.ml.spark.mllib.classification;

import com.datastax.insight.spec.RDDOperator;
import java.util.HashMap;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.DecisionTree;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import scala.Tuple2;

public class DecisionTreeClassifier
implements RDDOperator {
    public static DecisionTreeModel train(JavaRDD<LabeledPoint> data, int numClasses, int maxDepth, int maxBins) {
        return DecisionTreeClassifier.train(data, numClasses, "gini", maxDepth, maxBins);
    }

    public static DecisionTreeModel train(JavaRDD<LabeledPoint> data, int numClasses, String impurity, int maxDepth, int maxBins) {
        HashMap categoricalFeaturesInfo = new HashMap();
        DecisionTreeModel model = DecisionTree.trainClassifier(data, (int)numClasses, categoricalFeaturesInfo, (String)impurity, (int)maxDepth, (int)maxBins);
        return model;
    }

    public static JavaPairRDD<Double, Double> predict(JavaRDD<LabeledPoint> data, final DecisionTreeModel model) {
        JavaPairRDD predictionAndLabel = data.mapToPair((PairFunction)new PairFunction<LabeledPoint, Double, Double>(){

            public Tuple2<Double, Double> a(LabeledPoint p2) {
                return new Tuple2((Object)model.predict(p2.features()), (Object)p2.label());
            }

            public /* synthetic */ Tuple2 call(Object object) throws Exception {
                return this.a((LabeledPoint)object);
            }
        });
        return predictionAndLabel;
    }
}

