/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.ml.spark.mllib.classification;

import com.datastax.insight.spec.RDDOperator;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.mllib.classification.NaiveBayes;
import org.apache.spark.mllib.classification.NaiveBayesModel;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.rdd.RDD;
import scala.Tuple2;

public class NaiveBayesClassifier
implements RDDOperator {
    public static NaiveBayesModel train(JavaRDD<LabeledPoint> data, double lamda) {
        NaiveBayesModel model = NaiveBayes.train((RDD)data.rdd(), (double)lamda);
        return model;
    }

    public static JavaPairRDD<Double, Double> predict(JavaRDD<LabeledPoint> data, final NaiveBayesModel model) {
        JavaPairRDD predictionAndLabel = data.mapToPair((PairFunction)new PairFunction<LabeledPoint, Double, Double>(){

            public Tuple2<Double, Double> a(LabeledPoint p2) {
                return new Tuple2((Object)model.predict(p2.features()), (Object)p2.label());
            }

            public /* synthetic */ Tuple2 call(Object object) throws Exception {
                return this.a((LabeledPoint)object);
            }
        });
        return predictionAndLabel;
    }
}

