/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.ml.spark.mllib.classification;

import com.datastax.insight.core.util.LogUtil;
import com.datastax.insight.spec.RDDOperator;
import java.util.HashMap;
import java.util.List;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.RandomForest;
import org.apache.spark.mllib.tree.model.RandomForestModel;
import scala.Tuple2;

public class RandomForestClassifier
implements RDDOperator {
    private static LogUtil a = new LogUtil(RandomForestClassifier.class);

    public static RandomForestModel train(JavaRDD<LabeledPoint> data, int numClasses, int numTrees, String featureSubsetStrategy, int maxDepth, int maxBins, int seed) {
        return RandomForestClassifier.train(data, numClasses, numTrees, featureSubsetStrategy, "gini", maxDepth, maxBins, seed);
    }

    public static RandomForestModel train(JavaRDD<LabeledPoint> data, int numClasses, int numTrees, String featureSubsetStrategy, String impurity, int maxDepth, int maxBins, int seed) {
        HashMap categoricalFeaturesInfo = new HashMap();
        RandomForestModel model = RandomForest.trainClassifier(data, (int)numClasses, categoricalFeaturesInfo, (int)numTrees, (String)featureSubsetStrategy, (String)impurity, (int)maxDepth, (int)maxBins, (int)seed);
        return model;
    }

    public static JavaPairRDD<Double, Double> predict(JavaRDD<LabeledPoint> data, final RandomForestModel model) {
        JavaPairRDD predictionAndLabel = data.mapToPair((PairFunction)new PairFunction<LabeledPoint, Double, Double>(){

            public Tuple2<Double, Double> a(LabeledPoint p2) {
                Tuple2 tuple2 = new Tuple2((Object)model.predict(p2.features()), (Object)p2.label());
                return tuple2;
            }

            public /* synthetic */ Tuple2 call(Object object) throws Exception {
                return this.a((LabeledPoint)object);
            }
        });
        RandomForestClassifier.a((JavaPairRDD<Double, Double>)predictionAndLabel);
        Double testErr = 1.0 * (double)predictionAndLabel.filter((Function)new Function<Tuple2<Double, Double>, Boolean>(){

            public Boolean a(Tuple2<Double, Double> pl) {
                return !((Double)pl._1()).equals(pl._2());
            }

            public /* synthetic */ Object call(Object object) throws Exception {
                return this.a((Tuple2<Double, Double>)((Tuple2)object));
            }
        }).count() / (double)data.count();
        a.logUserOutputStart("predict");
        System.out.println("Test Error: " + testErr);
        a.logUserOutputEnd("predict");
        return predictionAndLabel;
    }

    private static void a(JavaPairRDD<Double, Double> predictionAndLabel) {
        List list = predictionAndLabel.collect();
        a.logUserOutputStart("predict");
        for (Tuple2 tuple2 : list) {
            System.out.println(tuple2.toString());
        }
        a.logUserOutputEnd("predict");
    }
}

