/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.ml.spark.mllib.classification;

import com.datastax.insight.spec.RDDOperator;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.mllib.classification.SVMModel;
import org.apache.spark.mllib.classification.SVMWithSGD;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.rdd.RDD;
import scala.Tuple2;

public class SVM
implements RDDOperator {
    public static SVMModel train(JavaRDD<LabeledPoint> data, int numIterations) {
        SVMModel model = SVMWithSGD.train((RDD)data.rdd(), (int)numIterations);
        model.clearThreshold();
        return model;
    }

    public static JavaRDD<Tuple2<Object, Object>> predict(JavaRDD<LabeledPoint> data, final SVMModel model) {
        JavaRDD scoreAndLabels = data.map((Function)new Function<LabeledPoint, Tuple2<Object, Object>>(){

            public Tuple2<Object, Object> a(LabeledPoint p2) {
                Double score = model.predict(p2.features());
                return new Tuple2((Object)score, (Object)p2.label());
            }

            public /* synthetic */ Object call(Object object) throws Exception {
                return this.a((LabeledPoint)object);
            }
        });
        return scoreAndLabels;
    }
}

