/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.ml.spark.mllib.cluster;

import com.datastax.insight.spec.RDDOperator;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.mllib.clustering.PowerIterationClustering;
import org.apache.spark.mllib.clustering.PowerIterationClusteringModel;
import scala.Tuple3;

public class PowerIterationCluster
implements RDDOperator {
    public static PowerIterationClusteringModel train(JavaRDD<String> rdd, final String delimiter, int numClasses, int maxIterations) {
        JavaRDD similarities = rdd.map((Function)new Function<String, Tuple3<Long, Long, Double>>(){

            public Tuple3<Long, Long, Double> a(String line) throws Exception {
                String delim = delimiter;
                if (delim == null || delim.length() == 0) {
                    delim = ";";
                }
                String[] items = line.split(delim);
                return new Tuple3((Object)Long.parseLong(items[0]), (Object)Long.parseLong(items[1]), (Object)Double.parseDouble(items[2]));
            }

            public /* synthetic */ Object call(Object object) throws Exception {
                return this.a((String)object);
            }
        });
        return PowerIterationCluster.train((JavaRDD<Tuple3<Long, Long, Double>>)similarities, numClasses, maxIterations);
    }

    public static PowerIterationClusteringModel train(JavaRDD<Tuple3<Long, Long, Double>> similarities, int numClasses, int maxIterations) {
        PowerIterationClustering pic = new PowerIterationClustering().setK(numClasses).setMaxIterations(maxIterations);
        PowerIterationClusteringModel model = pic.run(similarities);
        return model;
    }
}

