/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.ml.spark.mllib.evaluator;

import com.alibaba.fastjson.JSON;
import com.datastax.insight.core.entity.Metrics;
import com.datastax.insight.core.service.PersistService;
import com.datastax.insight.spec.RDDOperator;
import java.io.Serializable;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.mllib.classification.ClassificationModel;
import org.apache.spark.mllib.evaluation.MulticlassMetrics;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.TreeEnsembleModel;
import org.apache.spark.mllib.util.Saveable;
import scala.Tuple2;

public class MulticlassMetricsWrapper
implements RDDOperator {
    public Metrics evaluation(Saveable model, JavaRDD<LabeledPoint> data) {
        ClassificationModel realModel;
        JavaRDD scoreAndLabels = null;
        if (model instanceof ClassificationModel) {
            realModel = (ClassificationModel)model;
            scoreAndLabels = data.map((Function & Serializable)d2 -> new Tuple2((Object)realModel.predict(d2.features()), (Object)d2.label()));
        } else if (model instanceof DecisionTreeModel) {
            realModel = (DecisionTreeModel)model;
            scoreAndLabels = data.map(arg_0 -> MulticlassMetricsWrapper.lambda$evaluation$2be01bef$1((DecisionTreeModel)realModel, arg_0));
        } else if (model instanceof TreeEnsembleModel) {
            realModel = (TreeEnsembleModel)model;
            scoreAndLabels = data.map(arg_0 -> MulticlassMetricsWrapper.lambda$evaluation$60a0a262$1((TreeEnsembleModel)realModel, arg_0));
        } else {
            String message = "[" + model.getClass().getTypeName() + "] is not supported, currently supports: ClassificationModel, DecisionTreeModel, TreeEnsembleModel";
            throw new IllegalArgumentException(message);
        }
        Metrics metrics = new Metrics();
        MulticlassMetrics multiclassMetrics = new MulticlassMetrics(scoreAndLabels.rdd());
        metrics.getIndicator().setPrecision(multiclassMetrics.precision());
        metrics.getIndicator().setRecall(multiclassMetrics.recall());
        metrics.getIndicator().setfMeasure(multiclassMetrics.fMeasure());
        metrics.getIndicator().setAccuracy(multiclassMetrics.accuracy());
        metrics.getIndicator().setWeightedPrecision(multiclassMetrics.weightedPrecision());
        metrics.getIndicator().setWeightedRecall(multiclassMetrics.weightedRecall());
        metrics.getIndicator().setWeightedFMeasure(multiclassMetrics.weightedFMeasure());
        metrics.getIndicator().setWeightedTruePositiveRate(multiclassMetrics.weightedTruePositiveRate());
        metrics.getIndicator().setWeightedFalsePositiveRate(multiclassMetrics.weightedFalsePositiveRate());
        PersistService.invoke("com.datastax.insight.agent.dao.InsightDAO", "saveModelMetrics", new String[]{Long.class.getTypeName(), String.class.getTypeName()}, new Object[]{PersistService.getFlowId(), JSON.toJSONString(metrics)});
        return metrics;
    }

    private static /* synthetic */ Tuple2 lambda$evaluation$60a0a262$1(TreeEnsembleModel realModel, LabeledPoint d2) throws Exception {
        return new Tuple2((Object)realModel.predict(d2.features()), (Object)d2.label());
    }

    private static /* synthetic */ Tuple2 lambda$evaluation$2be01bef$1(DecisionTreeModel realModel, LabeledPoint d2) throws Exception {
        return new Tuple2((Object)realModel.predict(d2.features()), (Object)d2.label());
    }
}

