/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.ml.spark.mllib.evaluator;

import com.alibaba.fastjson.JSON;
import com.datastax.insight.core.entity.Metrics;
import com.datastax.insight.core.service.PersistService;
import com.datastax.insight.spec.RDDOperator;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.mllib.evaluation.RankingMetrics;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel;
import org.apache.spark.mllib.recommendation.Rating;
import scala.Tuple2;

public class RankingMetricsWrapper
implements RDDOperator {
    public Metrics evaluation(MatrixFactorizationModel model, JavaRDD<Rating> data) {
        JavaRDD userRecs = model.recommendProductsForUsers(10).toJavaRDD();
        JavaRDD userRecsScaled = userRecs.map((Function & Serializable)t2 -> {
            Rating[] scaledRating = new Rating[((Rating[])t2._2()).length];
            for (int i2 = 0; i2 < scaledRating.length; ++i2) {
                double newRating = Math.max(Math.min(((Rating[])t2._2())[i2].rating(), 1.0), 0.0);
                scaledRating[i2] = new Rating(((Rating[])t2._2())[i2].user(), ((Rating[])t2._2())[i2].product(), newRating);
            }
            return new Tuple2(t2._1(), (Object)scaledRating);
        });
        JavaPairRDD userRecommended = JavaPairRDD.fromJavaRDD((JavaRDD)userRecsScaled);
        JavaRDD binarizedRatings = data.map((Function & Serializable)r2 -> new Rating(r2.user(), r2.product(), r2.rating() > 0.0 ? 1.0 : 0.0));
        JavaPairRDD userProducts = binarizedRatings.groupBy((Function & Serializable)r2 -> r2.user());
        JavaPairRDD userProductsList = userProducts.mapValues((Function & Serializable)t2 -> {
            ArrayList<Integer> products = new ArrayList<Integer>();
            for (Rating r2 : t2) {
                if (!(r2.rating() > 0.0)) continue;
                products.add(r2.product());
            }
            return products;
        });
        JavaPairRDD userRecommendedList = userRecommended.mapValues((Function & Serializable)t2 -> {
            ArrayList<Integer> products = new ArrayList<Integer>();
            for (Rating r2 : t2) {
                products.add(r2.product());
            }
            return products;
        });
        JavaRDD relevantDocs = userProductsList.join(userRecommendedList).values();
        RankingMetrics rankingMetrics = RankingMetrics.of((JavaRDD)relevantDocs);
        Metrics metrics = new Metrics();
        metrics.getIndicator().setMeanAveragePrecision(rankingMetrics.meanAveragePrecision());
        PersistService.invoke("com.datastax.insight.agent.dao.InsightDAO", "saveModelMetrics", new String[]{Long.class.getTypeName(), String.class.getTypeName()}, new Object[]{PersistService.getFlowId(), JSON.toJSONString(metrics)});
        return metrics;
    }
}

