/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.ml.spark.mllib.feature;

import com.datastax.insight.spec.RDDOperator;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.mllib.feature.ChiSqSelector;
import org.apache.spark.mllib.feature.ChiSqSelectorModel;
import org.apache.spark.mllib.linalg.Vectors;
import org.apache.spark.mllib.regression.LabeledPoint;

public class ChiSqFeatureSelector
implements RDDOperator {
    public static JavaRDD<LabeledPoint> fit(JavaRDD<LabeledPoint> data, final int bins, int numFeatures) {
        JavaRDD discretizedData = data.map((Function)new Function<LabeledPoint, LabeledPoint>(){

            public LabeledPoint a(LabeledPoint lp) {
                double[] discretizedFeatures = new double[lp.features().size()];
                for (int i2 = 0; i2 < lp.features().size(); ++i2) {
                    discretizedFeatures[i2] = Math.floor(lp.features().apply(i2) / (double)bins);
                }
                return new LabeledPoint(lp.label(), Vectors.dense((double[])discretizedFeatures));
            }

            public /* synthetic */ Object call(Object object) throws Exception {
                return this.a((LabeledPoint)object);
            }
        });
        ChiSqSelector selector = new ChiSqSelector(numFeatures);
        final ChiSqSelectorModel transformer = selector.fit(discretizedData.rdd());
        JavaRDD filteredData = discretizedData.map((Function)new Function<LabeledPoint, LabeledPoint>(){

            public LabeledPoint a(LabeledPoint lp) {
                return new LabeledPoint(lp.label(), transformer.transform(lp.features()));
            }

            public /* synthetic */ Object call(Object object) throws Exception {
                return this.a((LabeledPoint)object);
            }
        });
        return filteredData;
    }
}

