/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.ml.spark.mllib.feature;

import com.datastax.insight.core.driver.SparkContextBuilder;
import com.datastax.insight.spec.RDDOperator;
import java.util.Arrays;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.distributed.RowMatrix;

public class PCAReducer
implements RDDOperator {
    public static JavaRDD<Vector> reduce(JavaRDD<Vector> data, int tpc) {
        RowMatrix mat = new RowMatrix(data.rdd());
        Matrix pc = mat.computePrincipalComponents(tpc);
        RowMatrix projected = mat.multiply(pc);
        Vector[] collectPartitions = (Vector[])projected.rows().collect();
        JavaRDD vectors = SparkContextBuilder.getJContext().parallelize(Arrays.asList(collectPartitions));
        return vectors;
    }
}

