/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.ml.spark.mllib.feature;

import com.datastax.insight.core.driver.SparkContextBuilder;
import com.datastax.insight.spec.RDDOperator;
import java.util.Arrays;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.linalg.SingularValueDecomposition;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.distributed.RowMatrix;

public class SVD
implements RDDOperator {
    public static JavaRDD<Vector> compute(JavaRDD<Vector> data, int topN, boolean computeU, double rCond) {
        RowMatrix mat = new RowMatrix(data.rdd());
        SingularValueDecomposition svd = mat.computeSVD(topN, computeU, rCond);
        RowMatrix U = (RowMatrix)svd.U();
        Vector[] collectPartitions = (Vector[])U.rows().collect();
        JavaRDD vectors = SparkContextBuilder.getJContext().parallelize(Arrays.asList(collectPartitions));
        return vectors;
    }
}

