/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.ml.spark.mllib.model;

import com.datastax.data.common.hadoop.a;
import com.datastax.insight.core.driver.SparkContextBuilder;
import com.datastax.insight.core.entity.Model;
import com.datastax.insight.core.service.PersistService;
import com.datastax.insight.spec.RDDOperator;
import com.datastax.util.lang.ReflectUtil;
import com.datastax.util.lang.StringUtil;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.classification.ClassificationModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel;
import org.apache.spark.mllib.regression.RegressionModel;
import org.apache.spark.mllib.util.Saveable;
import org.apache.spark.sql.SparkSession;

public class ModelHandler
implements RDDOperator {
    public static Saveable load(String modelId) {
        Model model = (Model)PersistService.invoke("com.datastax.insight.agent.dao.InsightDAO", "getModel", new String[]{String.class.getTypeName()}, new Object[]{modelId});
        return ModelHandler.a(model.getModelClass(), model.getPath());
    }

    private static Saveable a(String modelClass, String modelPath) {
        SparkContext ctx = SparkContextBuilder.getContext();
        return ModelHandler.a(ctx, modelClass, modelPath);
    }

    private static Saveable a(SparkContext ctx, String modelClass, String modelPath) {
        return (Saveable)ReflectUtil.invokeStaticMethod(modelClass, "load", new String[]{ctx.getClass().getTypeName(), String.class.getTypeName()}, ctx, modelPath);
    }

    public static void save(Saveable saveable, String modelName, String path, boolean replace) {
        String modelPath = path + "/" + modelName;
        if (replace) {
            ModelHandler.b(modelPath);
        }
        saveable.save(SparkContextBuilder.getContext(), modelPath);
        PersistService.invoke("com.datastax.insight.agent.dao.InsightDAO", "saveModel", new String[]{Long.class.getTypeName(), String.class.getTypeName(), String.class.getTypeName(), String.class.getTypeName()}, new Object[]{PersistService.getFlowId(), modelName, saveable.getClass().getName(), modelPath});
    }

    private static void b(String path) {
        String hdfs = StringUtil.substringIndent(path, "hdfs://", "/");
        if (hdfs != null) {
            hdfs = "hdfs://" + hdfs;
            path = path.replace(hdfs, "");
            Configuration configuration = new Configuration();
            configuration.set("fs.default.name", hdfs);
            try {
                a.a(configuration, path);
                System.out.println("datastax-Insight Model deleted with sucess, model path -> " + path);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    public static String predict(String modelId, String feature) {
        Saveable model = ModelHandler.load(modelId);
        return ModelHandler.a(model, feature);
    }

    public static String[] predict(String modelId, String[] feature) {
        Saveable model = ModelHandler.load(modelId);
        return ModelHandler.a(model, feature);
    }

    public static String predict(String modelClass, String modelPath, String feature) {
        Saveable model = ModelHandler.a(modelClass, modelPath);
        return ModelHandler.a(model, feature);
    }

    public static String[] predict(String modelClass, String modelPath, String[] feature) {
        Saveable model = ModelHandler.a(modelClass, modelPath);
        return ModelHandler.a(model, feature);
    }

    public static int[] recommendProducts(String modelClass, String modelPath, int userId, int num) {
        SparkSession spark = SparkSession.builder().appName("datastax-insight-" + System.currentTimeMillis()).master("local[*]").getOrCreate();
        Saveable model = ModelHandler.a(spark.sparkContext(), modelClass, modelPath);
        MatrixFactorizationModel als = (MatrixFactorizationModel)model;
        int[] result = Arrays.stream(als.recommendProducts(userId, num)).mapToInt(r2 -> r2.product()).toArray();
        spark.stop();
        return result;
    }

    public static int[] recommendUsers(String modelClass, String modelPath, int productId, int num) {
        Saveable model = ModelHandler.a(modelClass, modelPath);
        MatrixFactorizationModel als = (MatrixFactorizationModel)model;
        return Arrays.stream(als.recommendUsers(productId, num)).mapToInt(r2 -> r2.product()).toArray();
    }

    public static int[] recommendProducts(Saveable model, int userId, int num) {
        MatrixFactorizationModel als = (MatrixFactorizationModel)model;
        return Arrays.stream(als.recommendProducts(userId, num)).mapToInt(r2 -> r2.product()).toArray();
    }

    public static int[] recommendUsers(Saveable model, int productId, int num) {
        MatrixFactorizationModel als = (MatrixFactorizationModel)model;
        return Arrays.stream(als.recommendUsers(productId, num)).mapToInt(r2 -> r2.user()).toArray();
    }

    private static String a(Saveable model, String feature) {
        Vector vector = Vectors.dense((double[])Arrays.stream(feature.split(",")).mapToDouble(x2 -> Double.parseDouble(x2)).toArray());
        return ModelHandler.a(model, vector);
    }

    private static String a(Saveable model, Vector feature) {
        if (model instanceof ClassificationModel) {
            return String.valueOf(((ClassificationModel)model).predict(feature));
        }
        if (model instanceof RegressionModel) {
            return String.valueOf(((RegressionModel)model).predict(feature));
        }
        throw new UnsupportedOperationException("predict method is no support for Class:" + model.getClass().getTypeName());
    }

    private static String[] a(Saveable model, String[] features2) {
        Vector[] vectors = (Vector[])Arrays.stream(features2).map(d2 -> Vectors.dense((double[])Arrays.stream(d2.split(",")).mapToDouble(x2 -> Double.parseDouble(x2)).toArray())).toArray(Vector[]::new);
        return ModelHandler.a(model, vectors);
    }

    private static String[] a(Saveable model, Vector[] features2) {
        return (String[])Arrays.stream(features2).map(v2 -> String.valueOf(ModelHandler.a(model, v2))).toArray(String[]::new);
    }
}

