/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.ml.spark.mllib.recommendation.als;

import com.datastax.insight.core.driver.SparkContextBuilder;
import com.datastax.insight.ml.spark.mllib.recommendation.als.RatingRDDLoader;
import com.datastax.insight.spec.RDDOperator;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.recommendation.ALS;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel;
import org.apache.spark.mllib.recommendation.Rating;
import org.apache.spark.rdd.RDD;
import scala.Tuple2;

public class ALSWrapper
implements RDDOperator {
    private static final double r = 0.01;

    public static MatrixFactorizationModel train(JavaRDD<Rating> ratings, int rank, int iterations, double lambda, int blocks) {
        return ALS.train((RDD)ratings.rdd(), (int)rank, (int)iterations, (double)lambda, (int)blocks);
    }

    public static MatrixFactorizationModel train(JavaRDD<Rating> ratings, int rank, int iterations, int blocks) {
        return ALSWrapper.train(ratings, rank, iterations, 0.01, blocks);
    }

    public static MatrixFactorizationModel train(String ratingFilePath, int rank, int iterations, int blocks) {
        JavaRDD<Rating> ratings = RatingRDDLoader.fromTextFile(ratingFilePath);
        return ALSWrapper.train(ratings, rank, iterations, 0.01, blocks);
    }

    public static MatrixFactorizationModel train(String ratingFilePath, String delimiter, String[] propOrders, int rank, int iterations, int blocks) {
        JavaRDD<Rating> ratings = RatingRDDLoader.fromTextFile(ratingFilePath, delimiter, propOrders);
        return ALSWrapper.train(ratings, rank, iterations, 0.01, blocks);
    }

    public MatrixFactorizationModel loadModel(String path) {
        SparkContext sc = SparkContextBuilder.getContext();
        MatrixFactorizationModel model = MatrixFactorizationModel.load((SparkContext)sc, (String)path);
        sc.stop();
        return model;
    }

    public static void saveModel(MatrixFactorizationModel model, String path) {
        SparkContext sc = SparkContextBuilder.getContext();
        model.save(sc, path);
        sc.stop();
    }

    public double predict(MatrixFactorizationModel model, int user, int product) {
        double rank = model.predict(user, product);
        System.out.println("\u7528\u6237\u3010" + user + "\u3011\u5bf9\u5546\u54c1\u3010" + product + "\u3011\u7684\u9884\u6d4b\u8bc4\u5206\u4e3a\uff1a\u3010" + rank + "\u3011");
        return rank;
    }

    public JavaRDD<Rating> predict(MatrixFactorizationModel model, JavaPairRDD<Integer, Integer> userProducts) {
        return model.predict(userProducts);
    }

    public Rating[] recommendProducts(MatrixFactorizationModel model, int user, int num) {
        return model.recommendProducts(user, num);
    }

    public Rating[] recommendUsers(MatrixFactorizationModel model, int product, int num) {
        return model.recommendUsers(product, num);
    }

    public RDD<Tuple2<Object, Rating[]>> recommendProductsForUsers(MatrixFactorizationModel model, int num) {
        return model.recommendProductsForUsers(num);
    }

    public RDD<Tuple2<Object, Rating[]>> recommendUsersForProducts(MatrixFactorizationModel model, int num) {
        return model.recommendUsersForProducts(num);
    }
}

