/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.ml.spark.mllib.recommendation.als;

import com.alibaba.fastjson.JSON;
import com.datastax.insight.core.entity.Metrics;
import com.datastax.insight.core.service.PersistService;
import com.datastax.insight.spec.RDDOperator;
import java.io.Serializable;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.mllib.evaluation.RegressionMetrics;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel;
import org.apache.spark.mllib.recommendation.Rating;
import scala.Tuple2;

public class RatingMetrics
implements RDDOperator {
    public Metrics evaluation(MatrixFactorizationModel model, JavaRDD<Rating> data) {
        JavaPairRDD usersproducts = data.mapToPair((PairFunction & Serializable)d2 -> new Tuple2((Object)d2.user(), (Object)d2.product()));
        JavaPairRDD predictions = model.predict(usersproducts).mapToPair((PairFunction & Serializable)d2 -> new Tuple2((Object)new Tuple2((Object)d2.user(), (Object)d2.product()), (Object)d2.rating()));
        JavaPairRDD rawData = data.mapToPair((PairFunction & Serializable)d2 -> new Tuple2((Object)new Tuple2((Object)d2.user(), (Object)d2.product()), (Object)d2.rating()));
        JavaRDD predictedAndTrue = rawData.join(predictions).map((Function & Serializable)d2 -> new Tuple2(((Tuple2)d2._2())._1(), ((Tuple2)d2._2())._2()));
        RegressionMetrics regressionMetrics = new RegressionMetrics(predictedAndTrue.rdd());
        Metrics metrics = new Metrics();
        metrics.getIndicator().setMae(regressionMetrics.meanAbsoluteError());
        metrics.getIndicator().setMse(regressionMetrics.meanSquaredError());
        metrics.getIndicator().setRmse(regressionMetrics.rootMeanSquaredError());
        metrics.getIndicator().setR2(regressionMetrics.r2());
        PersistService.invoke("com.datastax.insight.agent.dao.InsightDAO", "saveModelMetrics", new String[]{Long.class.getTypeName(), String.class.getTypeName()}, new Object[]{PersistService.getFlowId(), JSON.toJSONString(metrics)});
        return metrics;
    }
}

