/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.ml.spark.mllib.recommendation.als;

import com.datastax.insight.ml.spark.data.rdd.RDDConverter;
import com.datastax.insight.ml.spark.data.rdd.RDDLoader;
import com.datastax.insight.spec.RDDOperator;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.recommendation.Rating;

public class RatingRDDLoader
implements RDDOperator {
    private static final String DELIMITER = "::";
    private static final String[] f = new String[]{"user", "product", "rating"};

    public static JavaRDD<Rating> fromTextFile(String path) {
        return RatingRDDLoader.fromTextFile(path, DELIMITER, f);
    }

    public static JavaRDD<Rating> fromTextFile(String path, final String delimiter, final String[] propOrders) {
        JavaRDD rdd = RDDLoader.load(path, new RDDConverter(){

            public Rating a(String line) {
                String[] tok = line.split(delimiter);
                int[] orders = new int[f.length];
                for (int i2 = 0; i2 < f.length; ++i2) {
                    for (int j2 = 0; j2 < propOrders.length; ++j2) {
                        if (!f[i2].equals(propOrders[j2])) continue;
                        orders[i2] = j2;
                    }
                }
                int x2 = Integer.parseInt(tok[orders[0]]);
                int y2 = Integer.parseInt(tok[orders[1]]);
                double rating = Double.parseDouble(tok[orders[2]]);
                return new Rating(x2, y2, rating);
            }

            public /* synthetic */ Object convert(String string) {
                return this.a(string);
            }
        });
        return rdd;
    }

    public static JavaRDD<Rating> fromTextFile(String path, String delimiter, String propList) {
        String[] propOrders = null;
        if (propList != null) {
            propOrders = propList.split(",");
        }
        if (delimiter == null) {
            delimiter = DELIMITER;
        }
        if (propOrders == null) {
            propOrders = f;
        }
        return RatingRDDLoader.fromTextFile(path, delimiter, propOrders);
    }
}

