/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.ml.spark.mllib.regression;

import com.datastax.insight.spec.RDDOperator;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.regression.LinearRegressionModel;
import org.apache.spark.mllib.regression.LinearRegressionWithSGD;
import org.apache.spark.rdd.RDD;
import scala.Tuple2;

public class LinearRegression
implements RDDOperator {
    public static LinearRegressionModel train(JavaRDD<LabeledPoint> data, int numIterations, double stepSize) {
        return LinearRegressionWithSGD.train((RDD)JavaRDD.toRDD(data), (int)numIterations, (double)stepSize);
    }

    public static JavaRDD<Tuple2<Double, Double>> predict(JavaRDD<LabeledPoint> data, final LinearRegressionModel model) {
        JavaRDD valuesAndPreds = data.map((Function)new Function<LabeledPoint, Tuple2<Double, Double>>(){

            public Tuple2<Double, Double> a(LabeledPoint point) {
                double prediction = model.predict(point.features());
                return new Tuple2((Object)prediction, (Object)point.label());
            }

            public /* synthetic */ Object call(Object object) throws Exception {
                return this.a((LabeledPoint)object);
            }
        });
        return valuesAndPreds;
    }
}

