/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.insight.ml.spark.mllib.regression;

import com.datastax.insight.spec.RDDOperator;
import java.util.HashMap;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.RandomForest;
import org.apache.spark.mllib.tree.model.RandomForestModel;
import scala.Tuple2;

public class RandomForestRegression
implements RDDOperator {
    public static RandomForestModel train(JavaRDD<LabeledPoint> data, int numTrees, String featureSubsetStrategy, int maxDepth, int maxBins, int seed) {
        return RandomForestRegression.train(data, numTrees, featureSubsetStrategy, "variance", maxDepth, maxBins, seed);
    }

    public static RandomForestModel train(JavaRDD<LabeledPoint> data, int numTrees, String featureSubsetStrategy, String impurity, int maxDepth, int maxBins, int seed) {
        HashMap categoricalFeaturesInfo = new HashMap();
        RandomForestModel model = RandomForest.trainRegressor(data, categoricalFeaturesInfo, (int)numTrees, (String)featureSubsetStrategy, (String)impurity, (int)maxDepth, (int)maxBins, (int)seed);
        return model;
    }

    public static JavaPairRDD<Double, Double> predict(JavaRDD<LabeledPoint> data, final RandomForestModel model) {
        JavaPairRDD predictionAndLabel = data.mapToPair((PairFunction)new PairFunction<LabeledPoint, Double, Double>(){

            public Tuple2<Double, Double> a(LabeledPoint p2) {
                return new Tuple2((Object)model.predict(p2.features()), (Object)p2.label());
            }

            public /* synthetic */ Tuple2 call(Object object) throws Exception {
                return this.a((LabeledPoint)object);
            }
        });
        return predictionAndLabel;
    }
}

