/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.util.collection;

import com.datastax.collection.KeyValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CollectionUtil {
    public static List<KeyValue<String, Long>> countListKV(List<String> list) {
        ArrayList<KeyValue<String, Long>> kvList = new ArrayList<KeyValue<String, Long>>();
        Map<String, Integer> map = CollectionUtil.countList(list);
        for (String key : map.keySet()) {
            kvList.add(new KeyValue<String, Long>(key, map.get(key).longValue()));
        }
        return kvList;
    }

    public static Map<String, Integer> countList(List<String> list) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (String value : list) {
            if (map.containsKey(value)) {
                int count = (Integer)map.get(value);
                map.remove(value);
                map.put(value, ++count);
                continue;
            }
            map.put(value, 1);
        }
        return map;
    }

    public static Map<String, Double> countListPercent(List<String> list) {
        Map<String, Integer> map = CollectionUtil.countList(list);
        return CollectionUtil.countMapPercent(map);
    }

    public static Map<String, Double> countMapPercent(Map<String, Integer> map) {
        HashMap<String, Double> perMap = new HashMap<String, Double>();
        double total = 0.0;
        for (String key : map.keySet()) {
            int weight = map.get(key);
            total += (double)weight;
        }
        for (String key : map.keySet()) {
            double weight = map.get(key).intValue();
            perMap.put(key, weight * 100.0 / total);
        }
        return perMap;
    }

    public static <K, V> List<Map.Entry<K, V>> sortMapByValue(Map<K, V> map, final int sort) {
        ArrayList<Map.Entry<K, V>> orderList = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(orderList, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                return ((Comparable)o2.getValue()).compareTo(o1.getValue()) * sort;
            }
        });
        return orderList;
    }

    public static <K, V> Map<Object, Map<K, V>> listToMap(List<Map<K, V>> list, Object idKey) {
        HashMap<Object, Map<V, Map<K, V>>> map = new HashMap<Object, Map<V, Map<K, V>>>();
        for (Map<K, V> item : list) {
            map.put(item.get(idKey), item);
        }
        return map;
    }

    public static String listToString(List list, String delimiter) {
        if (list == null || list.size() == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (i2 == 0) {
                sb.append(list.get(i2).toString());
                continue;
            }
            sb.append(delimiter + list.get(i2).toString());
        }
        return sb.toString();
    }

    public static List<String> removeDuplicate(List<String> list) {
        ArrayList<String> tmpList = new ArrayList<String>();
        for (String str : list) {
            if (tmpList.contains(str)) continue;
            tmpList.add(str);
        }
        return tmpList;
    }

    public static <T> List<List<T>> combine(List<T> list) {
        ArrayList<List<T>> retList = new ArrayList<List<T>>();
        int count = list.size();
        int nbit = 1 << count;
        for (int i2 = 0; i2 < nbit; ++i2) {
            ArrayList<T> itemList = new ArrayList<T>();
            for (int j2 = 0; j2 < count; ++j2) {
                if ((i2 & 1 << j2) == 0) continue;
                itemList.add(list.get(j2));
            }
            if (itemList.size() <= 0) continue;
            retList.add(itemList);
        }
        return retList;
    }

    public static <T> List<List<T>> combine(List<T> list, int num) {
        ArrayList<List<T>> retList = new ArrayList<List<T>>();
        int count = list.size();
        int nbit = 1 << count;
        for (int i2 = 0; i2 < nbit; ++i2) {
            ArrayList<T> itemList = new ArrayList<T>();
            for (int j2 = 0; j2 < count; ++j2) {
                if ((i2 & 1 << j2) == 0) continue;
                itemList.add(list.get(j2));
            }
            if (itemList.size() != num) continue;
            retList.add(itemList);
        }
        return retList;
    }

    public static <T> List<T> join(List<T> listOne, List<T> listTwo) {
        ArrayList<T> list = new ArrayList<T>();
        for (T t1 : listOne) {
            for (T t2 : listTwo) {
                if (!t1.equals(t2) || list.contains(t1)) continue;
                list.add(t1);
            }
        }
        return list;
    }

    public static <T> List<T> union(List<T> listOne, List<T> listTwo) {
        ArrayList<T> list = new ArrayList<T>();
        for (T t1 : listOne) {
            if (list.contains(t1)) continue;
            list.add(t1);
        }
        for (T t2 : listTwo) {
            if (list.contains(t2)) continue;
            list.add(t2);
        }
        return list;
    }

    public static void main(String[] args) {
        CollectionUtil.combineTest();
    }

    private static void combineTest() {
        ArrayList<String> items = new ArrayList<String>();
        items.add("a");
        items.add("b");
        items.add("c");
        List retList = CollectionUtil.combine(items);
        for (List itemList : retList) {
            for (String item : itemList) {
                System.out.print(item);
            }
            System.out.println();
        }
    }
}

