/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.util.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BigSAXParser
extends DefaultHandler {
    private String flag = null;
    private String[] keys;
    private Map<String, List<String>> map = new HashMap<String, List<String>>();

    public static Map<String, List<String>> extractData(InputStream is, String[] keys) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser parser = factory.newSAXParser();
            BigSAXParser bp = new BigSAXParser(keys);
            parser.parse(is, (DefaultHandler)bp);
            return bp.getData();
        }
        catch (ParserConfigurationException e2) {
            e2.printStackTrace();
        }
        catch (SAXException e3) {
            e3.printStackTrace();
        }
        catch (IOException e4) {
            e4.printStackTrace();
        }
        return null;
    }

    public static Map<String, List<String>> extractData(String uri, String[] keys) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser parser = factory.newSAXParser();
            BigSAXParser bp = new BigSAXParser(keys);
            parser.parse(uri, (DefaultHandler)bp);
            return bp.getData();
        }
        catch (ParserConfigurationException e2) {
            e2.printStackTrace();
        }
        catch (SAXException e3) {
            e3.printStackTrace();
        }
        catch (IOException e4) {
            e4.printStackTrace();
        }
        return null;
    }

    public static Map<String, List<String>> extractData(File file, String[] keys) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser parser = factory.newSAXParser();
            BigSAXParser bp = new BigSAXParser(keys);
            parser.parse(file, (DefaultHandler)bp);
            return bp.getData();
        }
        catch (ParserConfigurationException e2) {
            e2.printStackTrace();
        }
        catch (SAXException e3) {
            e3.printStackTrace();
        }
        catch (IOException e4) {
            e4.printStackTrace();
        }
        return null;
    }

    public BigSAXParser(String[] keys) {
        this.keys = keys;
        for (String key : keys) {
            this.map.put(key, new ArrayList());
        }
    }

    public Map<String, List<String>> getData() {
        return this.map;
    }

    private boolean isKey(String text) {
        for (String key : this.keys) {
            if (!key.equals(text)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void characters(char[] ch, int start2, int length) throws SAXException {
        String str = new String(ch, start2, length);
        if (this.isKey(this.flag)) {
            this.map.get(this.flag).add(str);
        }
        this.flag = this.isKey(str) ? str : null;
    }

    @Override
    public void startElement(String url, String LocalName, String qName, Attributes attr) throws SAXException {
    }

    @Override
    public void endElement(String url, String LocalName, String qName) throws SAXException {
    }
}

