/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.util.io;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassScanner {
    private Map<String, Class<?>> classes = new HashMap();
    private List<String> classList = new ArrayList<String>();
    private FilenameFilter javaClassFilter = (dir, name) -> !name.contains("$");
    private final String CLASS_FILE_SUFFIX = ".class";
    private String packPrefix;

    public Integer scan(String basePath, String packagePath, boolean recursive) throws ClassNotFoundException {
        this.packPrefix = basePath;
        String packTmp = packagePath.replace('.', '/');
        File dir = new File(basePath, packTmp);
        if (dir.isDirectory()) {
            this.scanDir(dir, recursive);
        }
        return this.classList.size();
    }

    public Integer scan(String packagePath, boolean recursive) {
        String filePackPath = packagePath.replace('.', '/');
        try {
            Enumeration<URL> dir = Thread.currentThread().getContextClassLoader().getResources(filePackPath);
            this.packPrefix = Thread.currentThread().getContextClassLoader().getResource("").getPath();
            if (System.getProperty("file.separator").equals("\\")) {
                this.packPrefix = this.packPrefix.substring(1);
            }
            while (dir.hasMoreElements()) {
                URL url = dir.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    File file = new File(url.getPath().substring(1));
                    this.scanDir(file, recursive);
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                this.scanJar(url, recursive);
            }
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
        return this.classList.size();
    }

    public void scanJar(URL url, boolean recursive) throws IOException, ClassNotFoundException {
        JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
        JarFile jarFile = jarURLConnection.getJarFile();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry jarEntry = entries.nextElement();
            String fileName = jarEntry.getName();
            if (jarEntry.isDirectory()) {
                if (!recursive) continue;
                continue;
            }
            if (!fileName.endsWith(".class")) continue;
            String className = fileName.substring(0, fileName.indexOf(46)).replace('/', '.');
            this.classList.add(className);
        }
    }

    private void scanDir(File dir, boolean recursive) {
        File[] fs = dir.listFiles(this.javaClassFilter);
        for (int i2 = 0; fs != null && i2 < fs.length; ++i2) {
            File f2 = fs[i2];
            String path = f2.getAbsolutePath();
            if (path.endsWith(".class")) {
                String className = ClassScanner.getPackageByPath(f2, this.packPrefix);
                this.classList.add(className);
            }
            if (!recursive) continue;
            this.scanDir(f2, recursive);
        }
    }

    private Map<String, Class<?>> getClasses() {
        return this.classes;
    }

    public List<String> getClassList() {
        return this.classList;
    }

    public List<String> getClassByType(String jarFile, String type, boolean childOnly) throws IOException, ClassNotFoundException {
        if (jarFile.contains("file:")) {
            jarFile = jarFile.replace("file:", "");
        }
        jarFile = "jar:file:" + jarFile + "!/";
        this.scanJar(new URL(jarFile), true);
        List<String> clzList = this.getClassList();
        ArrayList<String> classList = new ArrayList<String>();
        for (String clz : clzList) {
            if (childOnly && clz.equals(type)) continue;
            try {
                if (!Class.forName(type).isInstance(Class.forName(clz).newInstance())) continue;
                classList.add(clz);
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        return classList;
    }

    public static String convertToReflectGetMethod(String propertyName) {
        return "get" + ClassScanner.toFirstUpChar(propertyName);
    }

    public static String convertToReflectSetMethod(String propertyName) {
        return "set" + ClassScanner.toFirstUpChar(propertyName);
    }

    public static String toFirstUpChar(String target) {
        StringBuilder sb = new StringBuilder(target);
        sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        return sb.toString();
    }

    public static String getFileSuffixName(String fileName) {
        return fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase();
    }

    public static boolean isNotEmpty(String stringValue) {
        return null != stringValue && !"".equals(stringValue.trim());
    }

    public static String getPackageByPath(File classFile, String exclude) {
        if (classFile == null || classFile.isDirectory()) {
            return null;
        }
        String path = classFile.getAbsolutePath().replace('\\', '/');
        if ((path = path.substring(path.indexOf(exclude) + exclude.length()).replace('/', '.')).startsWith(".")) {
            path = path.substring(1);
        }
        if (path.endsWith(".")) {
            path = path.substring(0, path.length() - 1);
        }
        return path.substring(0, path.lastIndexOf(46));
    }
}

