/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.util.io;

import com.datastax.util.io.IOUtil;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;

public class FileIterator
implements Iterator<String> {
    String temp = null;
    private BufferedReader br = null;

    protected FileIterator(String path, String charEncoding) throws UnsupportedEncodingException, FileNotFoundException {
        this.br = IOUtil.getReader(path, charEncoding);
    }

    protected FileIterator(InputStream is, String charEncoding) throws UnsupportedEncodingException, FileNotFoundException {
        this.br = IOUtil.getReader(is, charEncoding);
    }

    @Override
    public boolean hasNext() {
        if (this.temp == null) {
            try {
                this.temp = this.br.readLine();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            return this.temp != null;
        }
        return true;
    }

    private String readLine() {
        try {
            if (this.temp == null) {
                this.temp = this.br.readLine();
            }
            String string = this.temp;
            return string;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            this.temp = null;
        }
    }

    public void close() {
        if (this.br != null) {
            try {
                this.br.close();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
    }

    @Override
    public String next() {
        return this.readLine();
    }

    @Override
    public void remove() {
        throw new RuntimeException("file iteartor can not remove ");
    }
}

