/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.util.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;

public class FileUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(File file) {
        String readStr = "";
        try {
            FileReader fileread = new FileReader(file);
            BufferedReader bufread = new BufferedReader(fileread);
            try {
                String read;
                while ((read = bufread.readLine()) != null) {
                    readStr = readStr + read + "\r\n";
                }
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            finally {
                if (bufread != null) {
                    bufread.close();
                }
                if (fileread != null) {
                    fileread.close();
                }
            }
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
        return readStr;
    }

    public static String readDir(File file, boolean printLog) {
        StringBuffer sb = new StringBuffer();
        if (file.isDirectory()) {
            File[] subFiles;
            for (File subFile : subFiles = file.listFiles()) {
                if (!subFile.isFile()) continue;
                if (printLog) {
                    System.out.println("\u6b63\u5728\u5904\u7406\u6587\u4ef6\uff1a" + subFile.getName());
                }
                sb.append(FileUtil.readFile(subFile));
            }
        } else {
            sb.append(FileUtil.readFile(file));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readFileText(File file) {
        ArrayList<String> texts = new ArrayList<String>();
        try {
            FileReader fileread = new FileReader(file);
            BufferedReader bufread = new BufferedReader(fileread);
            try {
                String read;
                while ((read = bufread.readLine()) != null) {
                    texts.add(read);
                }
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            finally {
                if (bufread != null) {
                    bufread.close();
                }
                if (fileread != null) {
                    fileread.close();
                }
            }
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
        return texts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readFileText(String path) {
        BufferedReader bufread = null;
        ArrayList<String> texts = new ArrayList<String>();
        try {
            File file = new File(path);
            if (file.exists()) {
                InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(path), "UTF-8");
                bufread = new BufferedReader(isr);
            } else {
                InputStream in = FileUtil.class.getResourceAsStream(path);
                bufread = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            }
            try {
                String read;
                while ((read = bufread.readLine()) != null) {
                    texts.add(read);
                }
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            finally {
                if (bufread != null) {
                    bufread.close();
                }
            }
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
        return texts;
    }

    public static String readFileString(String path) {
        StringBuffer sb = new StringBuffer();
        for (String line : FileUtil.readFileText(path)) {
            sb.append(line + "\r\n");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File file, String newStr, boolean append) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file, append)));
            writer.write(newStr);
        }
        catch (FileNotFoundException e2) {
            e2.printStackTrace();
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e4) {
                    e4.printStackTrace();
                }
            }
        }
    }

    public static void writeFile(File file, List<String> words, boolean append) {
        for (String word : words) {
            FileUtil.writeFile(file, word + "\r\n", append);
        }
    }

    public static void writeFileBatch(File file, List<String> words, boolean append) {
        FileUtil.writeFileBatch(file, words, append, "\r\n");
    }

    public static void writeFileBatch(File file, List<String> words, boolean append, String sep) {
        StringBuffer sb = new StringBuffer();
        int index = 0;
        for (String word : words) {
            if (index == words.size() - 1) {
                sb.append(word);
                continue;
            }
            sb.append(word + sep);
        }
        FileUtil.writeFile(file, sb.toString(), append);
    }

    public static void writeObject(String path, Object map) throws IOException {
        File f2 = new File(path);
        FileOutputStream out = new FileOutputStream(f2);
        ObjectOutputStream objwrite = new ObjectOutputStream(out);
        objwrite.writeObject(map);
        objwrite.flush();
        objwrite.close();
    }

    public static Object readObject(String path) throws IOException, ClassNotFoundException {
        FileInputStream in = new FileInputStream(path);
        ObjectInputStream objread = new ObjectInputStream(in);
        Object map = objread.readObject();
        objread.close();
        return map;
    }

    public static List<String> subDirList(File file) {
        File[] subFiles;
        ArrayList<String> dirs = new ArrayList<String>();
        for (File subFile : subFiles = file.listFiles()) {
            if (!subFile.isDirectory()) continue;
            dirs.add(subFile.getName());
        }
        return dirs;
    }

    public static String[] subDirs(File file) {
        List<String> dirList = FileUtil.subDirList(file);
        if (dirList == null || dirList.size() == 0) {
            return null;
        }
        String[] dirs = new String[dirList.size()];
        for (int i2 = 0; i2 < dirs.length; ++i2) {
            dirs[i2] = dirList.get(i2);
        }
        return dirs;
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i2 = 0; i2 < children.length; ++i2) {
                boolean success = FileUtil.deleteDir(new File(dir, children[i2]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }
}

