/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.util.io;

import com.datastax.util.io.FileIterator;
import com.datastax.util.lang.ReflectUtil;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class IOUtil {
    public static final String UTF8 = "utf-8";
    public static final String GBK = "gbk";
    public static final String TABLE = "\t";
    public static final String LINE = "\n";
    public static final byte[] TABBYTE = "\t".getBytes();
    public static final byte[] LINEBYTE = "\n".getBytes();

    public static InputStream getInputStream(String path) {
        try {
            return new FileInputStream(path);
        }
        catch (FileNotFoundException e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public static BufferedReader getReader(String path, String charEncoding) throws FileNotFoundException, UnsupportedEncodingException {
        return IOUtil.getReader(new File(path), charEncoding);
    }

    private static BufferedReader getReader(File file, String charEncoding) throws FileNotFoundException, UnsupportedEncodingException {
        FileInputStream is = new FileInputStream(file);
        return new BufferedReader(new InputStreamReader((InputStream)is, charEncoding));
    }

    public static RandomAccessFile getRandomAccessFile(String path, String charEncoding) throws FileNotFoundException {
        InputStream is = IOUtil.getInputStream(path);
        if (is != null) {
            return new RandomAccessFile(new File(path), "r");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void Writer(String path, String charEncoding, String content) {
        block7: {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(new File(path));
                ((OutputStream)fos).write(content.getBytes(charEncoding));
                fos.flush();
                IOUtil.close(fos);
            }
            catch (FileNotFoundException e2) {
                e2.printStackTrace();
            }
            catch (IOException e3) {
                e3.printStackTrace();
                break block7;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtil.close(fos);
            }
        }
    }

    public static byte[] inputStreamToByte(InputStream inputStream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int n2 = 0;
        while ((n2 = inputStream.read(buf)) >= 0) {
            baos.write(buf, 0, n2);
        }
        byte[] content = baos.toByteArray();
        return content;
    }

    public static BufferedReader getReader(InputStream inputStream, String charEncoding) throws UnsupportedEncodingException {
        return new BufferedReader(new InputStreamReader(inputStream, charEncoding));
    }

    public static String getContent(String path, String charEncoding) {
        return IOUtil.getContent(new File(path), charEncoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContent(InputStream is, String charEncoding) {
        BufferedReader reader = null;
        try {
            reader = IOUtil.getReader(is, charEncoding);
            String string = IOUtil.getContent(reader);
            return string;
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContent(File file, String charEncoding) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            String string = IOUtil.getContent(is, charEncoding);
            return string;
        }
        catch (FileNotFoundException e2) {
            e2.printStackTrace();
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (IOException e3) {
                e3.printStackTrace();
            }
        }
        return "";
    }

    public static String getContent(BufferedReader reader) throws IOException {
        StringBuilder sb = new StringBuilder();
        String temp = null;
        while ((temp = reader.readLine()) != null) {
            sb.append(temp);
            sb.append(LINE);
        }
        return sb.toString();
    }

    public static void WriterObj(String path, Serializable hm) throws IOException {
        try (ObjectOutputStream objectOutputStream = null;){
            objectOutputStream = new ObjectOutputStream(new FileOutputStream(path));
            objectOutputStream.writeObject(hm);
        }
    }

    public static void close(Reader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public static void close(InputStream is) {
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public static void close(OutputStream os) {
        try {
            if (os != null) {
                os.flush();
                os.close();
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public static FileIterator instanceFileIterator(String path, String charEncoding) {
        try {
            return IOUtil.instanceFileIterator(IOUtil.getInputStream(path), charEncoding);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public static FileIterator instanceFileIterator(InputStream is, String charEncoding) {
        try {
            return new FileIterator(is, charEncoding);
        }
        catch (UnsupportedEncodingException e2) {
            e2.printStackTrace();
        }
        catch (FileNotFoundException e3) {
            e3.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> HashMap<K, V> loadMap(String path, String charEncoding, Class<K> key, Class<V> value) throws UnsupportedEncodingException {
        HashMap<Object, Object> hm = null;
        try (FileIterator iteartor = null;){
            iteartor = IOUtil.instanceFileIterator(path, charEncoding);
            hm = new HashMap<Object, Object>();
            String[] split = null;
            while (iteartor.hasNext()) {
                String readLine = iteartor.next();
                split = readLine.split(TABLE);
                hm.put(ReflectUtil.conversion(split[0], key), ReflectUtil.conversion(split[1], value));
            }
        }
        return hm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> void writeMap(Map<K, V> hm, String path, String charEncoding) throws IOException {
        Iterator<Map.Entry<K, V>> iterator = hm.entrySet().iterator();
        Map.Entry<K, V> next = null;
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(path);
            while (iterator.hasNext()) {
                next = iterator.next();
                fos.write(next.getKey().toString().getBytes());
                fos.write(TABBYTE);
                fos.write(next.getValue().toString().getBytes());
                fos.write(LINEBYTE);
            }
            fos.flush();
        }
    }

    public static List<String> readFile2List(String path, String charEncoding) throws UnsupportedEncodingException, FileNotFoundException {
        return IOUtil.readFile2List(IOUtil.getReader(path, charEncoding));
    }

    public static List<String> readFile2List(File file, String charEncoding) throws FileNotFoundException, UnsupportedEncodingException {
        return IOUtil.readFile2List(IOUtil.getReader(file, charEncoding));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readFile2List(BufferedReader br) {
        ArrayList<String> all = new ArrayList<String>();
        String temp = null;
        try {
            while ((temp = br.readLine()) != null) {
                all.add(temp);
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e3) {
                e3.printStackTrace();
            }
        }
        return all;
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        HashMap loadMap = IOUtil.loadMap("/Users/dataexa/git/dataexa_seg/library/userLibrary/userLibrary.dic", UTF8, null, null);
        System.out.println(loadMap.get("\u6dd8\u5b9d"));
    }
}

