/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.util.lang;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class DateUtil {
    public static void main(String[] args) {
        Date endDate = new Date();
        Calendar c2 = Calendar.getInstance();
        c2.setTime(endDate);
        c2.add(5, -3);
        Date startDate = c2.getTime();
        System.out.println(startDate.before(endDate));
        List<Date> ranges = DateUtil.getRangeTime(startDate, endDate, 3);
        for (Date date : ranges) {
            System.out.println(date);
        }
    }

    public static Date getPreTime(Date date, int group) {
        Calendar c2 = Calendar.getInstance();
        c2.setTime(date);
        c2.set(13, 0);
        c2.set(14, 0);
        c2.set(12, 0);
        int hour = c2.get(11);
        int distance = hour % group;
        c2.add(11, -distance);
        return c2.getTime();
    }

    public static Date getNextTime(Date date, int group) {
        Calendar c2 = Calendar.getInstance();
        c2.setTime(date);
        c2.set(13, 0);
        c2.set(14, 0);
        c2.set(12, 0);
        int hour = c2.get(11);
        int distance = group - hour % group;
        c2.add(11, distance);
        return c2.getTime();
    }

    public static List<Date> getRangeTime(Date startDate, Date endDate, int group) {
        ArrayList<Date> range = new ArrayList<Date>();
        startDate = DateUtil.getPreTime(startDate, group);
        endDate = DateUtil.getNextTime(endDate, group);
        for (int i2 = 0; i2 < Integer.MAX_VALUE; ++i2) {
            Calendar c2 = Calendar.getInstance();
            c2.setTime(startDate);
            c2.add(10, i2 * group);
            range.add(c2.getTime());
            if (c2.getTime().equals(endDate)) break;
        }
        return range;
    }

    public static Date strToDate(String dateStr, String format) {
        Date date = null;
        if (dateStr != null && !dateStr.equals("")) {
            SimpleDateFormat df = new SimpleDateFormat(format);
            try {
                date = df.parse(dateStr);
            }
            catch (ParseException e2) {
                e2.printStackTrace();
            }
        }
        return date;
    }

    public static Date strToDate(String dateStr) {
        Date date = null;
        if (dateStr != null && !dateStr.equals("")) {
            if (dateStr.matches("\\d{4}-\\d{1,2}-\\d{1,2}")) {
                dateStr = dateStr + " 00:00";
            } else if (dateStr.matches("\\d{4}-\\d{1,2}-\\d{1,2} \\d{1,2}")) {
                dateStr = dateStr + ":00";
            } else {
                System.out.println(dateStr + " \u683c\u5f0f\u4e0d\u6b63\u786e");
                return null;
            }
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:ss");
            try {
                date = df.parse(dateStr);
            }
            catch (ParseException e2) {
                e2.printStackTrace();
            }
        }
        return date;
    }

    public static String dateToStr(Date date, String format) {
        return date == null ? "" : new SimpleDateFormat(format).format(date);
    }

    public static String dateToStr(Date date) {
        return date == null ? "" : new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(date);
    }

    public static String getCurrentDate() {
        SimpleDateFormat f2 = new SimpleDateFormat("yyyy-MM-dd");
        return f2.format(Calendar.getInstance().getTime());
    }

    public static String getPrintDate() {
        String printDate = "";
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        printDate = printDate + calendar.get(1) + "\u5e74";
        printDate = printDate + (calendar.get(2) + 1) + "\u6708";
        printDate = printDate + calendar.get(5) + "\u65e5";
        return printDate;
    }

    public static String getDateFromDateTime(Timestamp dateTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH:mm");
        return sdf.format(dateTime).toString();
    }

    public static Timestamp getNowTimestamp() {
        long curTime = System.currentTimeMillis();
        return new Timestamp(curTime);
    }

    public static String getShareTime(Timestamp shareTimestamp) {
        String curYear;
        String shareTime = "";
        String shareTimeFormat = DateUtil.getDateFromDateTime(shareTimestamp);
        Timestamp curTimestamp = DateUtil.getNowTimestamp();
        String curTimeFormat = DateUtil.getDateFromDateTime(curTimestamp);
        String shareYear = shareTimeFormat.substring(0, 4);
        if (shareYear.equals(curYear = curTimeFormat.substring(0, 4))) {
            long between = (curTimestamp.getTime() - shareTimestamp.getTime()) / 1000L;
            long day = between / 86400L;
            long hour = between % 86400L / 3600L;
            long min = between % 3600L / 60L;
            if (day == 0L && hour == 0L) {
                shareTime = min + "\u5206\u949f\u524d";
            } else if (day == 0L && hour > 0L) {
                String todayMin = shareTimeFormat.substring(shareTimeFormat.indexOf(" ") + 1, shareTimeFormat.length());
                shareTime = "\u4eca\u5929 " + todayMin;
            } else if (day > 0L) {
                String today;
                shareTime = today = shareTimeFormat.substring(shareTimeFormat.indexOf("\u5e74") + 1, shareTimeFormat.length());
            }
            return shareTime;
        }
        return shareTimeFormat;
    }
}

