/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.util.lang;

public class EncodingUtil {
    public static String chinaToUnicode(String str) {
        StringBuffer result = new StringBuffer();
        for (int i2 = 0; i2 < str.length(); ++i2) {
            char chr1 = str.charAt(i2);
            result.append("\\u" + Integer.toHexString(chr1));
        }
        return result.toString();
    }

    public static String unicodeToChinese(String str) {
        if (EncodingUtil.containsChinese(str)) {
            return str;
        }
        if (str.indexOf("\\u") == -1 || str == null || "".equals(str.trim())) {
            return str.replaceAll("\\\\ ", " ");
        }
        StringBuffer sb = new StringBuffer();
        if (!str.startsWith("\\u")) {
            int index = str.indexOf("\\u");
            sb.append(str.substring(0, index));
            str = str.substring(index);
        }
        if (str.endsWith(":")) {
            str = str.substring(0, str.length() - 1);
        }
        String[] chs = str.trim().split("\\\\u");
        for (int i2 = 0; i2 < chs.length; ++i2) {
            String ch = chs[i2].trim();
            if (ch == null || "".equals(ch)) continue;
            sb.append((char)Integer.parseInt(ch.substring(0, 4), 16));
            if (ch.length() <= 4) continue;
            sb.append(ch.substring(4));
        }
        return sb.toString();
    }

    public static boolean isAllChinese(String text) {
        char[] charArray = text.toCharArray();
        for (int i2 = 0; i2 < charArray.length; ++i2) {
            if (charArray[i2] >= '\u4e00' && charArray[i2] <= '\u9fbb') continue;
            return false;
        }
        return true;
    }

    public static boolean containsChinese(String word) {
        char[] input = word.trim().toCharArray();
        for (int i2 = 0; i2 < input.length; ++i2) {
            if (!Character.toString(input[i2]).matches("[\u4e00-\u9fa5]+")) continue;
            return true;
        }
        return false;
    }

    public static String resolveUnicode(String oldValue, boolean isToUnicode) {
        if (isToUnicode) {
            return EncodingUtil.chinaToUnicode(oldValue);
        }
        return EncodingUtil.unicodeToChinese(new String(oldValue));
    }
}

