/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.util.lang;

import com.datastax.util.lang.ProcessStreamHandler;
import com.datastax.util.lang.ThreadUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class ProcessUtil {
    private ProcessStreamHandler handler;
    private String workingDir;
    private List<String> stdoutList = new ArrayList<String>();
    private List<String> erroroutList = new ArrayList<String>();

    public ProcessUtil() {
    }

    public ProcessUtil(ProcessStreamHandler handler) {
        this.handler = handler;
    }

    public void setWorkingDir(String dir) {
        this.workingDir = dir;
    }

    public void execute(String command) {
        this.stdoutList.clear();
        this.erroroutList.clear();
        Process p2 = null;
        try {
            p2 = Runtime.getRuntime().exec(command);
            this.unblock(p2);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public void execute(String[] commands) {
        this.stdoutList.clear();
        this.erroroutList.clear();
        Process p2 = null;
        try {
            p2 = Runtime.getRuntime().exec(commands);
            this.unblock(p2);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public void builder(String ... commands) {
        this.stdoutList.clear();
        this.erroroutList.clear();
        Process p2 = null;
        try {
            p2 = null == this.workingDir ? new ProcessBuilder(commands).start() : new ProcessBuilder(commands).directory(new File(this.workingDir)).start();
            this.unblock(p2);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public void builder(List<String> commands) {
        this.stdoutList.clear();
        this.erroroutList.clear();
        Process p2 = null;
        try {
            p2 = null == this.workingDir ? new ProcessBuilder(commands).start() : new ProcessBuilder(commands).directory(new File(this.workingDir)).start();
            this.unblock(p2);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public void unblock(Process p2) {
        ThreadUtil stdoutUtil = new ThreadUtil(p2.getInputStream(), this.stdoutList, this.handler);
        ThreadUtil erroroutUtil = new ThreadUtil(p2.getErrorStream(), this.erroroutList, this.handler);
        stdoutUtil.start();
        erroroutUtil.start();
        try {
            p2.waitFor();
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
    }

    public List<String> getStdoutList() {
        return this.stdoutList;
    }

    public List<String> getErroroutList() {
        return this.erroroutList;
    }

    public void executeBlock(String command) {
        try {
            Process p2 = Runtime.getRuntime().exec(command);
            InputStream output = p2.getInputStream();
            this.handleStream(output);
            InputStream error = p2.getErrorStream();
            this.handleStream(error);
            p2.waitFor();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        catch (InterruptedException e3) {
            e3.printStackTrace();
        }
    }

    private void handleStream(InputStream inputStream) throws IOException {
        InputStreamReader isr = new InputStreamReader(inputStream);
        BufferedReader br = new BufferedReader(isr);
        String line = null;
        while ((line = br.readLine()) != null) {
            System.out.println(line);
        }
    }
}

