/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.util.lang;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ReflectObjectUtil {
    public static Map<String, Object> getKeyAndValue(Object obj) {
        if (obj == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        Class<?> objClass = obj.getClass();
        Field[] fs = objClass.getDeclaredFields();
        for (int i2 = 0; i2 < fs.length; ++i2) {
            Field f2 = fs[i2];
            f2.setAccessible(true);
            try {
                Object val = f2.get(obj);
                map.put(f2.getName(), val);
                continue;
            }
            catch (IllegalArgumentException e2) {
                e2.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e3) {
                e3.printStackTrace();
            }
        }
        return map;
    }

    public static <T> T copyToTarget(Object obj, T target) {
        if (obj == null) {
            return null;
        }
        Class<?> objClass = obj.getClass();
        Field[] fs = objClass.getDeclaredFields();
        Field[] superFs = objClass.getSuperclass().getDeclaredFields();
        ReflectObjectUtil.setFields(obj, target, fs, 0);
        ReflectObjectUtil.setFields(obj, target, superFs, 1);
        return target;
    }

    private static <T> void setFields(Object obj, T target, Field[] fs, int level) {
        Method[] methods = target.getClass().getMethods();
        for (int i2 = 0; i2 < fs.length; ++i2) {
            Field f2 = fs[i2];
            f2.setAccessible(true);
            try {
                Object val = f2.get(obj);
                for (Method method : methods) {
                    try {
                        Class<?> paramClass;
                        if (!method.getName().startsWith("set") || method.getParameterCount() != 1 || !(paramClass = method.getParameterTypes()[0]).equals(f2.getType())) continue;
                        if (paramClass.equals(Boolean.class) || paramClass.equals(Boolean.TYPE)) {
                            if (method.getName().toLowerCase().equals("set" + f2.getName().substring(2).toLowerCase())) {
                                method.invoke(target, val);
                                continue;
                            }
                            if (!method.getName().toLowerCase().equals("set" + f2.getName().toLowerCase())) continue;
                            method.invoke(target, val);
                            continue;
                        }
                        if (!method.getName().toLowerCase().equals("set" + f2.getName().toLowerCase())) continue;
                        method.invoke(target, val);
                    }
                    catch (InvocationTargetException e2) {
                        e2.printStackTrace();
                    }
                }
                continue;
            }
            catch (IllegalArgumentException e3) {
                e3.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e4) {
                e4.printStackTrace();
            }
        }
    }

    public static Object getValueByKey(Object obj, String key) {
        if (obj == null) {
            return null;
        }
        Class<?> objClass = obj.getClass();
        Field[] fs = objClass.getDeclaredFields();
        for (int i2 = 0; i2 < fs.length; ++i2) {
            Field f2 = fs[i2];
            f2.setAccessible(true);
            try {
                if (!f2.getName().endsWith(key)) continue;
                return f2.get(obj);
            }
            catch (IllegalArgumentException e2) {
                e2.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e3) {
                e3.printStackTrace();
            }
        }
        return null;
    }

    public static List<Map<String, Object>> getKeysAndValues(List<Object> list) {
        if (list == null) {
            return null;
        }
        return list.stream().map(obj -> ReflectObjectUtil.getKeyAndValue(obj)).collect(Collectors.toList());
    }

    public static List<Object> getValuesByKey(List<Object> list, String key) {
        if (list == null) {
            return null;
        }
        return list.stream().map(obj -> ReflectObjectUtil.getValueByKey(obj, key)).collect(Collectors.toList());
    }
}

