/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.util.lang;

import com.datastax.util.collection.ConcurrentReferenceHashMap;
import com.datastax.util.lang.StringUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ReflectUtil {
    private static final String CGLIB_RENAMED_METHOD_PREFIX = "CGLIB$";
    private static final Method[] NO_METHODS = new Method[0];
    private static final Field[] NO_FIELDS = new Field[0];
    private static Map<String, String> primitiveMap = ReflectUtil.initPrimitiveMap();
    private static final Map<Class<?>, Method[]> declaredMethodsCache = new ConcurrentReferenceHashMap(256);
    private static final Map<Class<?>, Field[]> declaredFieldsCache = new ConcurrentReferenceHashMap(256);
    public static FieldFilter COPYABLE_FIELDS = new FieldFilter(){

        @Override
        public boolean matches(Field field) {
            return !Modifier.isStatic(field.getModifiers()) && !Modifier.isFinal(field.getModifiers());
        }
    };
    public static MethodFilter NON_BRIDGED_METHODS = new MethodFilter(){

        @Override
        public boolean matches(Method method) {
            return !method.isBridge();
        }
    };
    public static MethodFilter USER_DECLARED_METHODS = new MethodFilter(){

        @Override
        public boolean matches(Method method) {
            return !method.isBridge() && method.getDeclaringClass() != Object.class;
        }
    };

    private static Map<String, String> initPrimitiveMap() {
        primitiveMap = new HashMap<String, String>();
        primitiveMap.put("int", "java.lang.Integer");
        primitiveMap.put("byte", "java.lang.Byte");
        primitiveMap.put("char", "java.lang.Char");
        primitiveMap.put("short", "java.lang.Short");
        primitiveMap.put("long", "java.lang.Long");
        primitiveMap.put("double", "java.lang.Double");
        primitiveMap.put("boolean", "java.lang.Boolean");
        primitiveMap.put("float", "java.lang.Float");
        return primitiveMap;
    }

    public static Field findField(Class<?> clazz, String name) {
        return ReflectUtil.findField(clazz, name, null);
    }

    public static Field findField(Class<?> clazz, String name, Class<?> type) {
        for (Class<?> searchType = clazz; Object.class != searchType && searchType != null; searchType = searchType.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = ReflectUtil.getDeclaredFields(searchType)) {
                if (name != null && !name.equals(field.getName()) || type != null && !type.equals(field.getType())) continue;
                return field;
            }
        }
        return null;
    }

    public static void setField(Field field, Object target, Object value) {
        try {
            field.set(target, value);
        }
        catch (IllegalAccessException ex) {
            ReflectUtil.handleReflectionException(ex);
            throw new IllegalStateException("Unexpected reflection exception - " + ex.getClass().getName() + ": " + ex.getMessage());
        }
    }

    public static Object getField(Field field, Object target) {
        try {
            return field.get(target);
        }
        catch (IllegalAccessException ex) {
            ReflectUtil.handleReflectionException(ex);
            throw new IllegalStateException("Unexpected reflection exception - " + ex.getClass().getName() + ": " + ex.getMessage());
        }
    }

    public static Object newInstance(String className, Object ... args) {
        try {
            Class<?> cls = Class.forName(className);
            if (args.length == 0) {
                return cls.newInstance();
            }
            Class[] paramClasses = new Class[args.length];
            for (int i2 = 0; i2 < paramClasses.length; ++i2) {
                paramClasses[i2] = args[i2].getClass();
            }
            Constructor<?> constructor = cls.getDeclaredConstructor(paramClasses);
            constructor.setAccessible(true);
            return constructor.newInstance(args);
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
        throw new IllegalStateException("Should never get here");
    }

    public static Method findMethod(Class<?> clazz, String name) {
        return ReflectUtil.findMethod(clazz, name, new Class[0]);
    }

    public static Method findMethod(Class<?> clazz, String name, String[] classTypes) throws ClassNotFoundException {
        Class[] classes = new Class[classTypes.length];
        for (int i2 = 0; i2 < classes.length; ++i2) {
            String classType = classTypes[i2];
            if (primitiveMap.containsKey(classType)) {
                classType = primitiveMap.get(classType);
            }
            Class<?> cls = classType.endsWith("String[]") ? new String[1].getClass() : (classType.endsWith("long[]") ? new long[1].getClass() : Class.forName(classType));
            classes[i2] = cls;
        }
        return ReflectUtil.findMethod(clazz, name, classes);
    }

    public static Method findMethod(Class<?> clazz, String name, Class<?> ... paramTypes) {
        for (Class<?> searchType = clazz; searchType != null; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.isInterface() ? searchType.getMethods() : ReflectUtil.getDeclaredMethods(searchType)) {
                if (!name.equals(method.getName()) || paramTypes != null && !ReflectUtil.arrayApprEquals(paramTypes, method.getParameterTypes())) continue;
                return method;
            }
        }
        return null;
    }

    private static boolean arrayEquals(Class[] array1, Class[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        int length = array1.length;
        if (array2.length != length) {
            return false;
        }
        for (int i2 = 0; i2 < length; ++i2) {
            Class o1 = array1[i2];
            Class o2 = array2[i2];
            for (String key : primitiveMap.keySet()) {
                String value = primitiveMap.get(key);
                if (o1.getName().equals(key) && o2.getName().equals(value)) {
                    return true;
                }
                if (!o1.getName().equals(value) || !o2.getName().equals(key)) continue;
                return true;
            }
            if (o1 != null ? o1.equals(o2) : o2 == null) continue;
            return false;
        }
        return true;
    }

    private static boolean arrayApprEquals(Class[] array1, Class[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        int length = array1.length;
        if (array2.length != length) {
            return false;
        }
        for (int i2 = 0; i2 < length; ++i2) {
            Class o1 = array1[i2];
            Class o2 = array2[i2];
            boolean sameType = false;
            for (String key : primitiveMap.keySet()) {
                String value = primitiveMap.get(key);
                if (o1.getName().equals(key) && o2.getName().equals(value)) {
                    sameType = true;
                    break;
                }
                if (!o1.getName().equals(value) || !o2.getName().equals(key)) continue;
                sameType = true;
                break;
            }
            if (sameType || o1.equals(o2) || o2.isAssignableFrom(o1)) continue;
            return false;
        }
        return true;
    }

    public static Object invokeMethod(Method method, Object target) {
        return ReflectUtil.invokeMethod(method, target, new Object[0]);
    }

    public static Object invokeMethod(Method method, Object target, Object ... args) {
        try {
            return method.invoke(target, args);
        }
        catch (Exception ex) {
            ReflectUtil.handleReflectionException(ex);
            throw new IllegalStateException("Should never get here");
        }
    }

    public static Object invokeMethod(String methodName, Object target, String[] classTypes, Object ... args) {
        String className = target.getClass().getTypeName();
        try {
            Method method = ReflectUtil.findMethod(target.getClass(), methodName, classTypes);
            return method.invoke(target, args);
        }
        catch (NullPointerException e2) {
            StackTraceElement[] elements;
            System.out.println("NullPointerException while invoking method\uff1a[" + className + "." + methodName + "]");
            System.out.println("********* argeuments *********");
            for (int i2 = 0; i2 < args.length; ++i2) {
                System.out.println("argeument[" + i2 + "] is null: " + Boolean.toString(args[i2] == null));
            }
            System.out.println("********* stack trace *********");
            System.out.println(e2.toString());
            for (StackTraceElement element : elements = e2.getStackTrace()) {
                System.out.println("\t" + element.toString());
            }
            if (e2.getCause() != null) {
                StackTraceElement[] causes;
                System.out.println("Caused by: " + e2.getCause().toString());
                for (StackTraceElement cause : causes = e2.getCause().getStackTrace()) {
                    System.out.println("\t" + cause.toString());
                }
            }
        }
        catch (Exception ex) {
            StackTraceElement[] elements;
            System.out.println("Exception while invoking method\uff1a[" + className + "." + methodName + "]");
            System.out.println("********* argeuments *********");
            for (int i3 = 0; i3 < classTypes.length; ++i3) {
                System.out.println("argeument[" + i3 + "]:    accept:" + classTypes[i3] + "    =>    found:" + args[i3].getClass().getTypeName());
            }
            System.out.println("********* stack trace *********");
            System.out.println(ex.toString());
            StackTraceElement[] causes = elements = ex.getStackTrace();
            int n2 = causes.length;
            for (int i4 = 0; i4 < n2; ++i4) {
                StackTraceElement element = causes[i4];
                System.out.println("\t" + element.toString());
            }
            System.out.println("Caused by: " + ex.getCause().toString());
            for (StackTraceElement cause : causes = ex.getCause().getStackTrace()) {
                System.out.println("\t" + cause.toString());
            }
            ReflectUtil.handleReflectionException(ex);
        }
        throw new IllegalStateException("Should never get here");
    }

    public static Object invokeMethod(String methodName, Object target, Object ... args) {
        String[] classTypes = new String[args.length];
        for (int i2 = 0; i2 < classTypes.length; ++i2) {
            classTypes[i2] = args[i2].getClass().getTypeName();
        }
        return ReflectUtil.invokeMethod(methodName, target, classTypes, args);
    }

    public static Object invokeMethod(String className, String methodName, Object ... args) {
        String[] classTypes = new String[args.length];
        for (int i2 = 0; i2 < classTypes.length; ++i2) {
            classTypes[i2] = args[i2].getClass().getTypeName();
        }
        return ReflectUtil.invokeMethod(className, methodName, classTypes, args);
    }

    public static Object invokeMethod(String className, String methodName, String[] classTypes, Object ... args) {
        try {
            Class<?> cls = Class.forName(className);
            Object target = cls.newInstance();
            Method method = ReflectUtil.findMethod(cls, methodName, classTypes);
            return method.invoke(target, args);
        }
        catch (NullPointerException e2) {
            StackTraceElement[] elements;
            System.out.println("NullPointerException while invoking method\uff1a[" + className + "." + methodName + "]");
            System.out.println("********* argeuments *********");
            for (int i2 = 0; i2 < args.length; ++i2) {
                System.out.println("argeument[" + i2 + "] is null: " + Boolean.toString(args[i2] == null));
            }
            System.out.println("********* stack trace *********");
            System.out.println(e2.toString());
            for (StackTraceElement element : elements = e2.getStackTrace()) {
                System.out.println("\t" + element.toString());
            }
            if (e2.getCause() != null) {
                StackTraceElement[] causes;
                System.out.println("Caused by: " + e2.getCause().toString());
                for (StackTraceElement cause : causes = e2.getCause().getStackTrace()) {
                    System.out.println("\t" + cause.toString());
                }
            }
        }
        catch (Exception ex) {
            StackTraceElement[] elements;
            System.out.println("Exception while invoking method\uff1a[" + className + "." + methodName + "]");
            System.out.println("********* argeuments *********");
            for (int i3 = 0; i3 < classTypes.length; ++i3) {
                System.out.println("argeument[" + i3 + "]:    accept:" + classTypes[i3] + "    =>    found:" + (args[i3] == null ? "null" : args[i3].getClass().getTypeName()));
            }
            System.out.println("********* stack trace *********");
            System.out.println(ex.toString());
            StackTraceElement[] causes = elements = ex.getStackTrace();
            int n2 = causes.length;
            for (int i4 = 0; i4 < n2; ++i4) {
                StackTraceElement element = causes[i4];
                System.out.println("\t" + element.toString());
            }
            System.out.println("Caused by: " + ex.getCause().toString());
            for (StackTraceElement cause : causes = ex.getCause().getStackTrace()) {
                System.out.println("\t" + cause.toString());
            }
            ReflectUtil.handleReflectionException(ex);
        }
        throw new IllegalStateException("Should never get here");
    }

    public static Object invokeStaticMethod(String className, String methodName, String[] classTypes, Object ... args) {
        try {
            Class<?> cls = Class.forName(className);
            Method method = ReflectUtil.findMethod(cls, methodName, classTypes);
            return ReflectUtil.invokeMethod(method, null, args);
        }
        catch (Exception ex) {
            ReflectUtil.handleReflectionException(ex);
            throw new IllegalStateException("Should never get here");
        }
    }

    public static Object invokeJdbcMethod(Method method, Object target) throws SQLException {
        return ReflectUtil.invokeJdbcMethod(method, target, new Object[0]);
    }

    public static Object invokeJdbcMethod(Method method, Object target, Object ... args) throws SQLException {
        try {
            return method.invoke(target, args);
        }
        catch (IllegalAccessException ex) {
            ReflectUtil.handleReflectionException(ex);
        }
        catch (InvocationTargetException ex) {
            if (ex.getTargetException() instanceof SQLException) {
                throw (SQLException)ex.getTargetException();
            }
            ReflectUtil.handleInvocationTargetException(ex);
        }
        throw new IllegalStateException("Should never get here");
    }

    public static void handleReflectionException(Exception ex) {
        if (ex instanceof NoSuchMethodException) {
            throw new IllegalStateException("Method not found: " + ex.getMessage());
        }
        if (ex instanceof IllegalAccessException) {
            throw new IllegalStateException("Could not access method: " + ex.getMessage());
        }
        if (ex instanceof InvocationTargetException) {
            ReflectUtil.handleInvocationTargetException((InvocationTargetException)ex);
        }
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        throw new UndeclaredThrowableException(ex);
    }

    public static void handleInvocationTargetException(InvocationTargetException ex) {
        ReflectUtil.rethrowRuntimeException(ex.getTargetException());
    }

    public static void rethrowRuntimeException(Throwable ex) {
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        if (ex instanceof Error) {
            throw (Error)ex;
        }
        throw new UndeclaredThrowableException(ex);
    }

    public static void rethrowException(Throwable ex) throws Exception {
        if (ex instanceof Exception) {
            throw (Exception)ex;
        }
        if (ex instanceof Error) {
            throw (Error)ex;
        }
        throw new UndeclaredThrowableException(ex);
    }

    public static boolean declaresException(Method method, Class<?> exceptionType) {
        Class<?>[] declaredExceptions;
        for (Class<?> declaredException : declaredExceptions = method.getExceptionTypes()) {
            if (!declaredException.isAssignableFrom(exceptionType)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPublicStaticFinal(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers);
    }

    public static boolean isEqualsMethod(Method method) {
        if (method == null || !method.getName().equals("equals")) {
            return false;
        }
        Class<?>[] paramTypes = method.getParameterTypes();
        return paramTypes.length == 1 && paramTypes[0] == Object.class;
    }

    public static boolean isHashCodeMethod(Method method) {
        return method != null && method.getName().equals("hashCode") && method.getParameterTypes().length == 0;
    }

    public static boolean isToStringMethod(Method method) {
        return method != null && method.getName().equals("toString") && method.getParameterTypes().length == 0;
    }

    public static boolean isObjectMethod(Method method) {
        if (method == null) {
            return false;
        }
        try {
            Object.class.getDeclaredMethod(method.getName(), method.getParameterTypes());
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean isCglibRenamedMethod(Method renamedMethod) {
        String name = renamedMethod.getName();
        if (name.startsWith(CGLIB_RENAMED_METHOD_PREFIX)) {
            int i2;
            for (i2 = name.length() - 1; i2 >= 0 && Character.isDigit(name.charAt(i2)); --i2) {
            }
            return i2 > CGLIB_RENAMED_METHOD_PREFIX.length() && i2 < name.length() - 1 && name.charAt(i2) == '$';
        }
        return false;
    }

    public static void makeAccessible(Field field) {
        if (!(Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers()) && !Modifier.isFinal(field.getModifiers()) || field.isAccessible())) {
            field.setAccessible(true);
        }
    }

    public static void makeAccessible(Method method) {
        if (!(Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()) || method.isAccessible())) {
            method.setAccessible(true);
        }
    }

    public static void makeAccessible(Constructor<?> ctor) {
        if (!(Modifier.isPublic(ctor.getModifiers()) && Modifier.isPublic(ctor.getDeclaringClass().getModifiers()) || ctor.isAccessible())) {
            ctor.setAccessible(true);
        }
    }

    public static void doWithLocalMethods(Class<?> clazz, MethodCallback mc) {
        Method[] methods;
        for (Method method : methods = ReflectUtil.getDeclaredMethods(clazz)) {
            try {
                mc.doWith(method);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalStateException("Not allowed to access method '" + method.getName() + "': " + ex);
            }
        }
    }

    public static void doWithMethods(Class<?> clazz, MethodCallback mc) {
        ReflectUtil.doWithMethods(clazz, mc, null);
    }

    public static void doWithMethods(Class<?> clazz, MethodCallback mc, MethodFilter mf) {
        Method[] methods = ReflectUtil.getDeclaredMethods(clazz);
        for (Method method : methods) {
            if (mf != null && !mf.matches(method)) continue;
            try {
                mc.doWith(method);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalStateException("Not allowed to access method '" + method.getName() + "': " + ex);
            }
        }
        if (clazz.getSuperclass() != null) {
            ReflectUtil.doWithMethods(clazz.getSuperclass(), mc, mf);
        } else if (clazz.isInterface()) {
            for (GenericDeclaration genericDeclaration : clazz.getInterfaces()) {
                ReflectUtil.doWithMethods(genericDeclaration, mc, mf);
            }
        }
    }

    public static Method[] getAllDeclaredMethods(Class<?> leafClass) {
        final ArrayList methods = new ArrayList(32);
        ReflectUtil.doWithMethods(leafClass, new MethodCallback(){

            @Override
            public void doWith(Method method) {
                methods.add(method);
            }
        });
        return methods.toArray(new Method[methods.size()]);
    }

    public static Method[] getUniqueDeclaredMethods(Class<?> leafClass) {
        final ArrayList methods = new ArrayList(32);
        ReflectUtil.doWithMethods(leafClass, new MethodCallback(){

            @Override
            public void doWith(Method method) {
                boolean knownSignature = false;
                Method methodBeingOverriddenWithCovariantReturnType = null;
                for (Method existingMethod : methods) {
                    if (!method.getName().equals(existingMethod.getName()) || !Arrays.equals(method.getParameterTypes(), existingMethod.getParameterTypes())) continue;
                    if (existingMethod.getReturnType() != method.getReturnType() && existingMethod.getReturnType().isAssignableFrom(method.getReturnType())) {
                        methodBeingOverriddenWithCovariantReturnType = existingMethod;
                        break;
                    }
                    knownSignature = true;
                    break;
                }
                if (methodBeingOverriddenWithCovariantReturnType != null) {
                    methods.remove(methodBeingOverriddenWithCovariantReturnType);
                }
                if (!knownSignature && !ReflectUtil.isCglibRenamedMethod(method)) {
                    methods.add(method);
                }
            }
        });
        return methods.toArray(new Method[methods.size()]);
    }

    private static Method[] getDeclaredMethods(Class<?> clazz) {
        Method[] result = declaredMethodsCache.get(clazz);
        if (result == null) {
            Method[] declaredMethods = clazz.getDeclaredMethods();
            List<Method> defaultMethods = ReflectUtil.findConcreteMethodsOnInterfaces(clazz);
            if (defaultMethods != null) {
                result = new Method[declaredMethods.length + defaultMethods.size()];
                System.arraycopy(declaredMethods, 0, result, 0, declaredMethods.length);
                int index = declaredMethods.length;
                Iterator<Method> iterator = defaultMethods.iterator();
                while (iterator.hasNext()) {
                    Method defaultMethod;
                    result[index] = defaultMethod = iterator.next();
                    ++index;
                }
            } else {
                result = declaredMethods;
            }
            declaredMethodsCache.put(clazz, result.length == 0 ? NO_METHODS : result);
        }
        return result;
    }

    private static List<Method> findConcreteMethodsOnInterfaces(Class<?> clazz) {
        LinkedList<Method> result = null;
        for (Class<?> ifc : clazz.getInterfaces()) {
            for (Method ifcMethod : ifc.getMethods()) {
                if (Modifier.isAbstract(ifcMethod.getModifiers())) continue;
                if (result == null) {
                    result = new LinkedList<Method>();
                }
                result.add(ifcMethod);
            }
        }
        return result;
    }

    public static void doWithLocalFields(Class<?> clazz, FieldCallback fc) {
        for (Field field : ReflectUtil.getDeclaredFields(clazz)) {
            try {
                fc.doWith(field);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalStateException("Not allowed to access field '" + field.getName() + "': " + ex);
            }
        }
    }

    public static void doWithFields(Class<?> clazz, FieldCallback fc) {
        ReflectUtil.doWithFields(clazz, fc, null);
    }

    public static void doWithFields(Class<?> clazz, FieldCallback fc, FieldFilter ff) {
        Class<?> targetClass = clazz;
        do {
            Field[] fields;
            for (Field field : fields = ReflectUtil.getDeclaredFields(targetClass)) {
                if (ff != null && !ff.matches(field)) continue;
                try {
                    fc.doWith(field);
                }
                catch (IllegalAccessException ex) {
                    throw new IllegalStateException("Not allowed to access field '" + field.getName() + "': " + ex);
                }
            }
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
    }

    private static Field[] getDeclaredFields(Class<?> clazz) {
        Field[] result = declaredFieldsCache.get(clazz);
        if (result == null) {
            result = clazz.getDeclaredFields();
            declaredFieldsCache.put(clazz, result.length == 0 ? NO_FIELDS : result);
        }
        return result;
    }

    public static void shallowCopyFieldState(final Object src, final Object dest) {
        if (src == null) {
            throw new IllegalArgumentException("Source for field copy cannot be null");
        }
        if (dest == null) {
            throw new IllegalArgumentException("Destination for field copy cannot be null");
        }
        if (!src.getClass().isAssignableFrom(dest.getClass())) {
            throw new IllegalArgumentException("Destination class [" + dest.getClass().getName() + "] must be same or subclass as source class [" + src.getClass().getName() + "]");
        }
        ReflectUtil.doWithFields(src.getClass(), new FieldCallback(){

            @Override
            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                ReflectUtil.makeAccessible(field);
                Object srcValue = field.get(src);
                field.set(dest, srcValue);
            }
        }, COPYABLE_FIELDS);
    }

    public static void clearCache() {
        declaredMethodsCache.clear();
        declaredFieldsCache.clear();
    }

    public static void main(String[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object o2 = ReflectUtil.invokeMethod("com.datastax.util.lang.StringUtil", "substringIndent", "20g16", "0", "6");
        System.out.println(o2);
    }

    public static Object conversion(String value, Class<?> c2) {
        if (String.class.equals(c2)) {
            return value;
        }
        if (Integer.class.equals(c2)) {
            return Integer.parseInt(value);
        }
        if (Double.class.equals(c2)) {
            return Double.parseDouble(value);
        }
        if (Float.class.equals(c2)) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (Long.class.equals(c2)) {
            return Long.parseLong(value);
        }
        return value;
    }

    public static Object evaluateExpression(String expression, Map<String, Object> instanceMap) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Object object = null;
        String methodFullName = null;
        String className = null;
        if (expression.contains(".") && expression.contains("(") && (methodFullName = expression.substring(0, expression.indexOf("("))).contains(".")) {
            className = methodFullName.substring(0, methodFullName.lastIndexOf("."));
        }
        if (className != null && instanceMap.containsKey(className)) {
            String methodName = methodFullName.substring(methodFullName.lastIndexOf(".") + 1);
            String argText = StringUtil.substringFirstAndLast(expression, "(", ")");
            Object instance = instanceMap.get(className);
            Class<?> clazz = instance.getClass();
            if (argText == null) {
                Method method = clazz.getMethod(methodName, new Class[0]);
                object = method.invoke(instance, new Object[0]);
            } else {
                String[] arguments = argText.split(",");
                Object[] args = new Object[arguments.length];
                List<Method> methodList = ReflectUtil.getMethods(clazz, methodName, args.length);
                for (Method method : methodList) {
                    Class<?>[] paramTypes = method.getParameterTypes();
                    for (int i2 = 0; i2 < args.length; ++i2) {
                        Class<?> paramType = paramTypes[i2];
                        String arg = arguments[i2];
                        args[i2] = arg.contains(".") && arg.contains("(") ? ReflectUtil.evaluateExpression(arg, instanceMap) : (String.class.equals(paramType) ? arg.replaceAll("\"", "") : (instanceMap.containsKey(arg) ? instanceMap.get(arg) : ReflectUtil.conversion(arg, paramType)));
                    }
                    try {
                        object = method.invoke(instance, args);
                        break;
                    }
                    catch (Exception exception) {
                    }
                }
            }
        } else {
            object = instanceMap.containsKey(expression) ? instanceMap.get(expression) : expression;
        }
        return object;
    }

    private static Class[] getClasses(Object[] instances) {
        Class[] classes = new Class[instances.length];
        for (int i2 = 0; i2 < instances.length; ++i2) {
            Object instance = instances[i2];
            classes[i2] = instance.getClass();
        }
        return classes;
    }

    public static List<Method> getMethods(Class clazz, String methodName, int paramNum) throws NoSuchMethodException {
        Method[] methods;
        ArrayList<Method> methodList = new ArrayList<Method>();
        for (Method method : methods = clazz.getMethods()) {
            int paramCount;
            if (!method.getName().equals(methodName) || (paramCount = method.getParameterTypes().length) != paramNum) continue;
            methodList.add(method);
        }
        return methodList;
    }

    public static List<String> getObjectMethods() {
        Method[] methods;
        ArrayList<String> methodList = new ArrayList<String>();
        for (Method method : methods = Object.class.getMethods()) {
            methodList.add(method.getName());
        }
        return methodList;
    }

    public static interface FieldFilter {
        public boolean matches(Field var1);
    }

    public static interface FieldCallback {
        public void doWith(Field var1) throws IllegalArgumentException, IllegalAccessException;
    }

    public static interface MethodFilter {
        public boolean matches(Method var1);
    }

    public static interface MethodCallback {
        public void doWith(Method var1) throws IllegalArgumentException, IllegalAccessException;
    }
}

