/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.util.lang;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexUtil {
    public static void main(String[] args) {
        RegexUtil.test3();
    }

    private static void test1() {
        String text = "(\u8868B)\u6d4b\u8bd5";
        System.out.println(RegexUtil.ExtractByPattern(text, "(\\()(.+?)(\\)\u6d4b\u8bd5)", 2));
    }

    private static void test2() {
        String text = "A<-X->Cn";
        String pattern = "(.+?)(?:-|<-)(.+?)(?:->|-)(.*)";
        List<String> list = RegexUtil.ExtractByPatternAll(text, pattern);
        System.out.print(list);
    }

    private static void test3() {
        String url = "http://www.xxx.com/{1-1000}.html";
        String pattern = "(\\{)(.+?)(-)(.+?)(\\})";
        List<String> list = RegexUtil.ExtractByPatternAll(url, pattern);
        System.out.print(list);
    }

    public static List<String> ExtractByPatternAll(String text, String pattern) {
        if (text == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        Pattern p2 = Pattern.compile(pattern);
        Matcher m2 = p2.matcher(text);
        while (m2.find()) {
            for (int i2 = 1; i2 <= m2.groupCount(); ++i2) {
                list.add(m2.group(i2));
            }
        }
        return list;
    }

    public static List<String> ExtractByPattern(String text, String pattern, int group) {
        if (text == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        Pattern p2 = Pattern.compile(pattern);
        Matcher m2 = p2.matcher(text);
        while (m2.find()) {
            list.add(m2.group(group));
        }
        return list;
    }

    public static List<String> ExtractByPattern(String text, String pattern) {
        return RegexUtil.ExtractByPattern(text, pattern, 1);
    }

    public static String filter(String str, String reg) {
        Pattern pattern = Pattern.compile(reg);
        Matcher matcher = pattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        boolean result1 = matcher.find();
        while (result1) {
            matcher.appendReplacement(sb, "");
            result1 = matcher.find();
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String replace(String regex, String text, String replaceText) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(text);
        StringBuffer sb = new StringBuffer();
        boolean result1 = matcher.find();
        while (result1) {
            matcher.appendReplacement(sb, replaceText);
            result1 = matcher.find();
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static boolean matches(String regex, String text) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(text);
        return matcher.matches();
    }
}

