/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.util.lang;

import com.datastax.collection.KeyValue;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class StringUtil {
    private static final char DY = '\'';
    private static final char DH = ',';
    private static int[] filter = new int[128];
    private static int[] filterEnd = new int[128];

    public static String rmHtmlTag(String input) {
        if (StringUtil.isBlank(input)) {
            return "";
        }
        int length = input.length();
        int tl = 0;
        StringBuilder sb = new StringBuilder();
        char c2 = '\u0000';
        block5: for (int i2 = 0; i2 < length; ++i2) {
            c2 = input.charAt(i2);
            if (c2 > '\u007f') {
                sb.append(c2);
                continue;
            }
            switch (filter[c2]) {
                case -1: {
                    continue block5;
                }
                case 0: {
                    sb.append(c2);
                    continue block5;
                }
                case 1: {
                    if (sb.length() > 0 && sb.charAt(sb.length() - 1) != c2) {
                        sb.append(c2);
                    }
                    while (++i2 < length && input.charAt(i2) == c2) {
                    }
                    if (i2 >= length && input.charAt(length - 1) == c2) continue block5;
                    --i2;
                    continue block5;
                }
                default: {
                    tl = filter[c2] + i2;
                    int tempOff = i2++;
                    boolean flag = false;
                    char end = (char)filterEnd[c2];
                    while (i2 < length && i2 < tl) {
                        c2 = input.charAt(i2);
                        if (c2 <= '\u007f' && c2 == end) {
                            flag = true;
                            break;
                        }
                        ++i2;
                    }
                    if (flag) continue block5;
                    i2 = tempOff;
                    sb.append(input.charAt(i2));
                }
            }
        }
        return sb.toString();
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i2 = 0; i2 < strLen; ++i2) {
            if (Character.isWhitespace(cs.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !StringUtil.isBlank(cs);
    }

    public static String makeSqlInString(String str) {
        String[] strs = str.split(",");
        StringBuilder sb = new StringBuilder();
        String field = null;
        for (int i2 = 0; i2 < strs.length; ++i2) {
            field = strs[i2].trim();
            if (!StringUtil.isNotBlank(field)) continue;
            sb.append('\'');
            sb.append(field);
            sb.append('\'');
            if (i2 >= strs.length - 1) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    public static char[] sortCharArray(String str) {
        char[] chars = str.toCharArray();
        Arrays.sort(chars);
        return chars;
    }

    public static boolean isBlank(char[] chars) {
        int strLen;
        if (chars == null || (strLen = chars.length) == 0) {
            return true;
        }
        for (int i2 = 0; i2 < strLen; ++i2) {
            if (Character.isWhitespace(chars[i2])) continue;
            return false;
        }
        return true;
    }

    public static String substring(String text, String startText, String endText) {
        int start2 = text.indexOf(startText);
        if (start2 < 0) {
            return null;
        }
        start2 += startText.length();
        int end = text.indexOf(endText);
        if (end < 0) {
            return null;
        }
        return text.substring(start2, end);
    }

    public static String substringLast(String text, String startText, String endText) {
        int start2 = text.lastIndexOf(startText);
        if (start2 < 0) {
            return null;
        }
        start2 += startText.length();
        int end = text.lastIndexOf(endText);
        if (end < 0) {
            return null;
        }
        return text.substring(start2, end);
    }

    public static String substringIndent(String text, String startText, String endText) {
        int start2 = text.indexOf(startText);
        if (start2 < 0) {
            return null;
        }
        int end = text.indexOf(endText, start2 += startText.length());
        if (end < 0) {
            return null;
        }
        return text.substring(start2, end);
    }

    public static String substringIndent(String text, String[][] patternGroups) {
        for (String[] pattern : patternGroups) {
            String startText = pattern[0];
            String endText = pattern[1];
            int start2 = text.indexOf(startText);
            if (start2 < 0) {
                return null;
            }
            int end = text.indexOf(endText, start2 += startText.length());
            if (end < 0) {
                return null;
            }
            if (end <= start2) continue;
            return text.substring(start2, end);
        }
        return null;
    }

    public static void substringAll(String text, String startText, String endText, List<String> valueList) {
        int start2 = text.indexOf(startText);
        if (start2 < 0) {
            return;
        }
        int end = text.indexOf(endText, start2 += startText.length());
        String ret = null;
        if (end < 0) {
            ret = text.substring(start2);
            valueList.add(ret);
            return;
        }
        ret = text.substring(start2, end);
        text = text.substring(end);
        valueList.add(ret);
        StringUtil.substringAll(text, startText, endText, valueList);
    }

    public static String substringIndentLast(String text, String startText, String endText) {
        int start2 = text.lastIndexOf(startText);
        if (start2 < 0) {
            return null;
        }
        int end = text.indexOf(endText, start2 += startText.length());
        if (end < 0) {
            return null;
        }
        return text.substring(start2, end);
    }

    public static String substringFirstAndLast(String text, String startText, String endText) {
        int start2 = text.indexOf(startText);
        int end = text.lastIndexOf(endText);
        if (end - start2 <= 1) {
            return null;
        }
        return text.substring(start2 + 1, end);
    }

    public static String streamToString(InputStream is) {
        return StringUtil.streamToString(is, "utf-8");
    }

    public static String objToString(Object obj) {
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    public static String streamToString(InputStream is, String encoding, boolean newLine) {
        String ret = null;
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(is, encoding));
            StringBuffer buffer = new StringBuffer();
            String line = "";
            while ((line = in.readLine()) != null) {
                buffer.append(line);
                if (!newLine) continue;
                buffer.append("\n");
            }
            ret = buffer.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public static String streamToString(InputStream is, String encoding) {
        if (is == null) {
            return null;
        }
        String ret = null;
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(is, encoding));
            StringBuffer buffer = new StringBuffer();
            String line = "";
            while ((line = in.readLine()) != null) {
                buffer.append(line);
            }
            ret = buffer.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return ret;
    }

    public static InputStream stringToStream(String text) {
        return StringUtil.stringToStream(text, "utf-8");
    }

    public static InputStream stringToStream(String text, String encoding) {
        try {
            return new ByteArrayInputStream(text.getBytes(encoding));
        }
        catch (UnsupportedEncodingException e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public static boolean isNumeric(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        for (int i2 = 0; i2 < sz; ++i2) {
            if (Character.isDigit(str.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean containsNum(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        for (int i2 = 0; i2 < sz; ++i2) {
            if (!Character.isDigit(str.charAt(i2))) continue;
            return true;
        }
        return false;
    }

    public static boolean isEng(String str) {
        char[] chars = str.toCharArray();
        boolean isPhontic = false;
        for (int i2 = 0; i2 < chars.length; ++i2) {
            boolean bl = isPhontic = chars[i2] >= 'a' && chars[i2] <= 'z' || chars[i2] >= 'A' && chars[i2] <= 'Z';
            if (isPhontic) continue;
            return false;
        }
        return true;
    }

    public static boolean containsEng(String str) {
        char[] chars = str.toCharArray();
        boolean isPhontic = false;
        for (int i2 = 0; i2 < chars.length; ++i2) {
            boolean bl = isPhontic = chars[i2] >= 'a' && chars[i2] <= 'z' || chars[i2] >= 'A' && chars[i2] <= 'Z';
            if (!isPhontic) continue;
            return true;
        }
        return false;
    }

    public static double formatDecimal(double d2, String format) {
        DecimalFormat df = new DecimalFormat(format);
        return Double.parseDouble(df.format(d2));
    }

    public static String formatJScript(String html) {
        if (null == html) {
            return html;
        }
        html = html.replace("\\r", "");
        html = html.replace("\\n", "");
        html = html.replace("\\t", "");
        html = html.replace("\\\"", "\"");
        html = html.replace("\\/", "/");
        return html;
    }

    public static <T> String listToString(List<T> list, String sep) {
        StringBuffer sb = new StringBuffer();
        for (T str : list) {
            sb.append(str + sep);
        }
        String ret = sb.toString();
        if (ret.length() > 0) {
            ret = ret.substring(0, ret.length() - 1);
        }
        return ret;
    }

    public static <T> String listToString(List<T> list, String sep, String surrounder) {
        StringBuffer sb = new StringBuffer();
        for (T str : list) {
            sb.append(surrounder + str + surrounder + sep);
        }
        String ret = sb.toString();
        if (ret.length() > 0) {
            ret = ret.substring(0, ret.length() - 1);
        }
        return ret;
    }

    public static <T> String arrayToString(T[] list, String sep) {
        StringBuffer sb = new StringBuffer();
        for (T str : list) {
            sb.append(str + sep);
        }
        String ret = sb.toString();
        if (ret.length() > 0) {
            ret = ret.substring(0, ret.length() - 1);
        }
        return ret;
    }

    public static String replace(String string, String pattern, String replacement) {
        String replaced = null;
        if (string == null) {
            replaced = null;
        } else if (pattern == null || pattern.length() == 0) {
            replaced = string;
        } else {
            StringBuffer sb = new StringBuffer();
            int lastIndex = 0;
            int index = string.indexOf(pattern);
            while (index >= 0) {
                sb.append(string.substring(lastIndex, index));
                sb.append(replacement);
                lastIndex = index + pattern.length();
                index = string.indexOf(pattern, lastIndex);
            }
            sb.append(string.substring(lastIndex));
            replaced = sb.toString();
        }
        return replaced;
    }

    public static String replace(String string, String pattern, String replacement, int start2) {
        String begin = string.substring(0, start2);
        String end = string.substring(start2);
        return begin + StringUtil.replace(end, pattern, replacement);
    }

    public static int countWord(String text, String word) {
        int counter = 0;
        int index = 0;
        while (index >= 0) {
            index = text.indexOf(word);
            if (index < 0) continue;
            ++counter;
            text = text.substring(index + word.length());
        }
        return counter;
    }

    public static boolean inList(String[] list, String text) {
        for (String word : list) {
            if (!word.equals(text)) continue;
            return true;
        }
        return false;
    }

    public static boolean inList(List<String> list, String text) {
        for (String word : list) {
            if (!word.equals(text)) continue;
            return true;
        }
        return false;
    }

    public static long extractNum(String text) {
        StringBuffer sb = new StringBuffer();
        if (text == null) {
            return -1L;
        }
        int sz = text.length();
        for (int i2 = 0; i2 < sz; ++i2) {
            if (!Character.isDigit(text.charAt(i2))) continue;
            sb.append(text.charAt(i2));
        }
        return Long.parseLong(sb.toString());
    }

    public static String trim(String text) {
        if (text == null) {
            return null;
        }
        return text.trim().replace("\r\n", "").replace("\n", "").replace(" ", "").replace("\t", "");
    }

    public static String removeBlock(String text, String startText, String endText, boolean keepBlock) {
        int start2 = text.indexOf(startText);
        if (start2 < 0) {
            return text;
        }
        int end = text.indexOf(endText, start2 += startText.length());
        if (end < 0) {
            return text;
        }
        StringBuffer sb = new StringBuffer();
        if (keepBlock) {
            sb.append(text.substring(0, start2 - startText.length()));
            sb.append(text.substring(end));
        } else {
            sb.append(text.substring(0, start2));
            sb.append(text.substring(end + endText.length()));
        }
        return sb.toString();
    }

    public static List<KeyValue<String, Boolean>> split(String text, List<String> dicts) {
        List<KeyValue<String, Boolean>> tList = new ArrayList<KeyValue<String, Boolean>>();
        tList.add(new KeyValue<String, Boolean>(text, false));
        for (String dict : dicts) {
            tList = StringUtil.split(tList, dict);
        }
        return tList;
    }

    private static List<KeyValue<String, Boolean>> split(List<KeyValue<String, Boolean>> wList, String dict) {
        ArrayList<KeyValue<String, Boolean>> list = new ArrayList<KeyValue<String, Boolean>>();
        for (KeyValue<String, Boolean> keyValue : wList) {
            String key = keyValue.key();
            boolean value = keyValue.value();
            if (value) {
                list.add(new KeyValue<String, Boolean>(key, value));
                continue;
            }
            String[] texts = key.split(dict);
            if (texts.length > 1) {
                for (String t2 : texts) {
                    if (t2.length() > 0) {
                        list.add(new KeyValue<String, Boolean>(t2, false));
                    }
                    list.add(new KeyValue<String, Boolean>(dict, true));
                }
                list.remove(list.size() - 1);
                continue;
            }
            if (texts.length <= 0 || texts[0] == null) continue;
            if ((texts[0] + dict).equals(key)) {
                list.add(new KeyValue<String, Boolean>(texts[0], false));
                list.add(new KeyValue<String, Boolean>(dict, true));
                continue;
            }
            list.add(new KeyValue<String, Boolean>(key, value));
        }
        return list;
    }

    public static void main(String[] args) {
        StringUtil.test1();
    }

    private static void test1() {
        String text = "Face\u65f7\u4e16\u7684A\u8f6e\u6295\u8d44\u65b9\u6295\u4e86\u5fae\u4fe1\u7684B\u8f6e\u3001\u817e\u8baf\u7684C\u8f6e\u3001\u963f\u91cc\u7684B\u8f6e\u3002";
        ArrayList<String> dicts = new ArrayList<String>();
        dicts.add("A\u8f6e");
        dicts.add("B\u8f6e");
        dicts.add("Face\u65f7\u4e16");
        List<KeyValue<String, Boolean>> list = StringUtil.split(text, dicts);
        System.out.println(list);
    }

    private static void test2() {
        String text = "\u771f\u683c\u57fa\u91d1\u7684A\u8f6e";
        ArrayList<String> dicts = new ArrayList<String>();
        dicts.add("A\u8f6e");
        dicts.add("\u771f\u683c\u57fa\u91d1");
        List<KeyValue<String, Boolean>> list = StringUtil.split(text, dicts);
        System.out.println(list);
    }

    static {
        StringUtil.filter[60] = 0x3FFFFFFF;
        StringUtil.filterEnd[60] = 62;
        StringUtil.filter[38] = 10;
        StringUtil.filterEnd[38] = 59;
        StringUtil.filter[59] = -1;
        StringUtil.filter[10] = -1;
        StringUtil.filter[13] = -1;
        StringUtil.filter[9] = -1;
        StringUtil.filter[32] = 1;
        StringUtil.filter[42] = 1;
        StringUtil.filter[45] = 1;
        StringUtil.filter[46] = 1;
        StringUtil.filter[35] = 1;
    }
}

