/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.util.lang;

import com.datastax.util.lang.ProcessStreamHandler;
import com.datastax.util.lang.ProcessUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;

class ThreadUtil
implements Runnable {
    private String character = "UTF-8";
    private List<String> list;
    private InputStream inputStream;
    private ProcessStreamHandler handler;

    public ThreadUtil(InputStream inputStream, List<String> list, ProcessStreamHandler handler) {
        this.inputStream = inputStream;
        this.list = list;
        this.handler = handler;
    }

    public void start() {
        Thread thread = new Thread(this);
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public void run() {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(this.inputStream, this.character));
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line == null) continue;
                if (this.handler != null) {
                    this.handler.handle(line);
                } else {
                    System.out.println(line);
                }
                this.list.add(line);
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        finally {
            try {
                this.inputStream.close();
                br.close();
            }
            catch (IOException e3) {
                e3.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        ProcessUtil processUtil = new ProcessUtil();
        processUtil.setWorkingDir("/Users/andershong/Downloads/im2txt");
        processUtil.builder("python3", "run_inference.py", "--dir_path", "./picture");
        for (String str : processUtil.getStdoutList()) {
            System.out.println(str);
        }
    }
}

