/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.util.thread;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class DataExaThreadFactory
implements ThreadFactory {
    private static final AtomicInteger poolNumber = new AtomicInteger(1);
    private final ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix;
    private final boolean daemon;

    public DataExaThreadFactory() {
        SecurityManager s2 = System.getSecurityManager();
        this.group = s2 != null ? s2.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.namePrefix = "[DataExa] pool-" + poolNumber.getAndIncrement() + "-thread-";
        this.daemon = false;
    }

    public DataExaThreadFactory(String poolName) {
        SecurityManager s2 = System.getSecurityManager();
        this.group = s2 != null ? s2.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.namePrefix = "[" + poolName + "] pool-" + poolNumber.getAndIncrement() + "-thread-";
        this.daemon = false;
    }

    public DataExaThreadFactory(String poolName, boolean isDaemon) {
        SecurityManager s2 = System.getSecurityManager();
        this.group = s2 != null ? s2.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.namePrefix = "[" + poolName + "] pool-" + poolNumber.getAndIncrement() + "-thread-";
        this.daemon = isDaemon;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread t2 = new Thread(this.group, runnable, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
        if (t2.isDaemon()) {
            t2.setDaemon(this.daemon);
        }
        if (t2.getPriority() != 5) {
            t2.setPriority(5);
        }
        return t2;
    }
}

