/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.util.thread;

import java.util.ArrayList;
import java.util.List;

public abstract class ThreadDispatcher<T> {
    List<List<T>> groupT = new ArrayList<List<T>>();

    public abstract void runIt(List<T> var1);

    public ThreadDispatcher(List<T> list, int threadNum) {
        int total = list.size();
        int group = 0;
        group = total % threadNum == 0 ? total / threadNum : total / threadNum + 1;
        if (threadNum > list.size()) {
            threadNum = list.size();
        }
        for (int i2 = 0; i2 < threadNum; ++i2) {
            ArrayList<T> threadT = new ArrayList<T>();
            for (int j2 = 0; j2 < group; ++j2) {
                int idx = i2 * group + j2;
                if (idx >= total) continue;
                threadT.add(list.get(idx));
            }
            this.groupT.add(threadT);
        }
    }

    public void process() {
        int i2;
        Thread[] threads = new Thread[this.groupT.size()];
        for (i2 = 0; i2 < threads.length; ++i2) {
            threads[i2] = new DispatchThread(this.groupT.get(i2));
            threads[i2].setName("Thread" + i2);
        }
        for (i2 = 0; i2 < threads.length; ++i2) {
            threads[i2].start();
        }
    }

    public class DispatchThread
    extends Thread {
        protected List<T> list;

        public DispatchThread(List<T> list) {
            this.list = list;
        }

        @Override
        public void run() {
            ThreadDispatcher.this.runIt(this.list);
        }
    }
}

