/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.util.web;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HtmlUtil {
    private static final String regxpForHtml = "<([^>]*)>";

    public static void main(String[] args) {
        String text = "\u9ebb\u75b9<img src=\"/static/lemma/view/img/authorityIcon_4235f3dd.gif\" class=\"authorityIcon\" title=\"\u6743\u5a01\u4e13\u5bb6\u8ba4\u8bc1\u8bcd\u6761\"/>";
        System.out.println(HtmlUtil.filterHtml(text));
    }

    public String replaceTag(String input) {
        if (!this.hasSpecialChars(input)) {
            return input;
        }
        StringBuffer filtered = new StringBuffer(input.length());
        block6: for (int i2 = 0; i2 <= input.length() - 1; ++i2) {
            char c2 = input.charAt(i2);
            switch (c2) {
                case '<': {
                    filtered.append("&lt;");
                    continue block6;
                }
                case '>': {
                    filtered.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    filtered.append("&quot;");
                    continue block6;
                }
                case '&': {
                    filtered.append("&amp;");
                    continue block6;
                }
                default: {
                    filtered.append(c2);
                }
            }
        }
        return filtered.toString();
    }

    public boolean hasSpecialChars(String input) {
        boolean flag = false;
        if (input != null && input.length() > 0) {
            block6: for (int i2 = 0; i2 <= input.length() - 1; ++i2) {
                char c2 = input.charAt(i2);
                switch (c2) {
                    case '>': {
                        flag = true;
                        continue block6;
                    }
                    case '<': {
                        flag = true;
                        continue block6;
                    }
                    case '\"': {
                        flag = true;
                        continue block6;
                    }
                    case '&': {
                        flag = true;
                    }
                }
            }
        }
        return flag;
    }

    public static String filterHtml(String str) {
        Pattern pattern = Pattern.compile(regxpForHtml);
        Matcher matcher = pattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        boolean result1 = matcher.find();
        while (result1) {
            matcher.appendReplacement(sb, "");
            result1 = matcher.find();
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String filterHtmlForTemplate(String str) {
        Pattern pattern = Pattern.compile(regxpForHtml);
        Matcher matcher = pattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        boolean result1 = matcher.find();
        while (result1) {
            matcher.appendReplacement(sb, " ");
            result1 = matcher.find();
        }
        matcher.appendTail(sb);
        return sb.toString().replaceAll("[\\n|\\s]+", " ");
    }

    public static String fiterHtmlTag(String str, String tag) {
        String regxp = "<\\s*" + tag + "\\s+([^>]*)\\s*>";
        Pattern pattern = Pattern.compile(regxp);
        Matcher matcher = pattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        boolean result1 = matcher.find();
        while (result1) {
            matcher.appendReplacement(sb, "");
            result1 = matcher.find();
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String clearStyleOrScript(String content) {
        String result = content;
        result = result.replaceAll("<\\s*?(style)[^>]*>[\\s\\S]*?</\\s*?(style)\\s*?>", "");
        result = result.replaceAll("<\\s*?(STYLE)[^>]*>[\\s\\S]*?</\\s*?(STYLE)\\s*?>", "");
        result = result.replaceAll("<\\s*?(script)[^>]*>[\\s\\S]*?</\\s*?(script)\\s*?>", "");
        result = result.replaceAll("<\\s*?(SCRIPT)[^>]*>[\\s\\S]*?</\\s*?(SCRIPT)\\s*?>", "");
        return result;
    }

    public static String replaceHtmlTag(String str, String beforeTag, String tagAttrib, String startTag, String endTag) {
        String regxpForTag = "<\\s*" + beforeTag + "\\s+([^>]*)\\s*>";
        String regxpForTagAttrib = tagAttrib + "=\"([^\"]+)\"";
        Pattern patternForTag = Pattern.compile(regxpForTag);
        Pattern patternForAttrib = Pattern.compile(regxpForTagAttrib);
        Matcher matcherForTag = patternForTag.matcher(str);
        StringBuffer sb = new StringBuffer();
        boolean result = matcherForTag.find();
        while (result) {
            StringBuffer sbreplace = new StringBuffer();
            Matcher matcherForAttrib = patternForAttrib.matcher(matcherForTag.group(1));
            if (matcherForAttrib.find()) {
                matcherForAttrib.appendReplacement(sbreplace, startTag + matcherForAttrib.group(1) + endTag);
            }
            matcherForTag.appendReplacement(sb, sbreplace.toString());
            result = matcherForTag.find();
        }
        matcherForTag.appendTail(sb);
        return sb.toString();
    }

    public static List<String> getHtmlTag(String str, String tag) {
        String regxp = "<\\s*" + tag + "\\s+([^>]*)\\s*>";
        Pattern pattern = Pattern.compile(regxp);
        Matcher matcher = pattern.matcher(str);
        ArrayList<String> list = new ArrayList<String>();
        boolean result1 = matcher.find();
        while (result1) {
            list.add(matcher.group());
            result1 = matcher.find();
        }
        return list;
    }

    public static List<String> getTagContent(String tag, String content) {
        ArrayList<String> list = new ArrayList<String>();
        String reg = "<\\s*?(" + tag + ")[^>]*>[\\s\\S]*?</\\s*?(" + tag + ")\\s*?>";
        Pattern p2 = Pattern.compile(reg);
        Matcher m2 = p2.matcher(content);
        while (m2.find()) {
            list.add(m2.group());
        }
        return list;
    }

    public static String getTagProperty(String tagName, String property, String content) {
        String str = "";
        Pattern p2 = Pattern.compile("<" + tagName + "[^>]*?" + property + "\\s*=\\s*([\"]?)([^\"]+)");
        Matcher m2 = p2.matcher(content);
        if (m2.find()) {
            str = m2.group();
        }
        str = str.replaceAll("<" + tagName + "[^>]*?" + property + "\\s*=\\s*([\"]?)", "");
        return str;
    }
}

