/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.util.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.map.ObjectMapper;

public class JSONUtil {
    public static HashMap<String, Object> jsonToMap(String json) {
        JsonFactory factory = new JsonFactory();
        ObjectMapper mapper = new ObjectMapper(factory);
        org.codehaus.jackson.type.TypeReference<HashMap<String, Object>> typeRef = new org.codehaus.jackson.type.TypeReference<HashMap<String, Object>>(){};
        try {
            return (HashMap)mapper.readValue(json, (org.codehaus.jackson.type.TypeReference)typeRef);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public static List<String> jsonToList(String json) {
        JsonFactory factory = new JsonFactory();
        ObjectMapper mapper = new ObjectMapper(factory);
        org.codehaus.jackson.type.TypeReference<List<String>> typeRef = new org.codehaus.jackson.type.TypeReference<List<String>>(){};
        try {
            return (List)mapper.readValue(json, (org.codehaus.jackson.type.TypeReference)typeRef);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public static Object find(HashMap<String, Object> map, String path) {
        String[] nodes = path.split("/");
        for (int i2 = 0; i2 < nodes.length; ++i2) {
            String node = nodes[i2];
            if (i2 == nodes.length - 1) {
                return map.get(node);
            }
            map = (HashMap)map.get(node);
        }
        return null;
    }

    public static Object findAdvance(HashMap<String, Object> map, String path) {
        String[] nodes = path.split("/");
        Object o2 = map.get(nodes[0]);
        for (int i2 = 1; i2 < nodes.length; ++i2) {
            String node = nodes[i2];
            if (o2 instanceof List) {
                node = node.replace("[", "").replace("]", "");
                o2 = ((List)o2).get(Integer.parseInt(node));
                continue;
            }
            if (!(o2 instanceof Map)) continue;
            o2 = ((Map)o2).get(node);
        }
        return o2;
    }

    public static String toJson(Object obj) {
        return JSON.toJSONString(obj);
    }

    public static <T> T getEntity(String jsonString, Class<T> clazz) {
        return JSON.parseObject(jsonString, clazz);
    }

    public static <T> T getEntity(String json, TypeReference<T> type) {
        return JSON.parseObject(json, type, new Feature[0]);
    }

    public static <T> List<T> parseList(String json, Class<T> clazz) {
        return JSON.parseArray(json, clazz);
    }

    public static <T> T[] parseArray(String json, Class<T> clazz) {
        List<Object> list = JSONUtil.parseList(json, clazz);
        Object[] ts = (Object[])Array.newInstance(clazz, list.size());
        ts = list.toArray(ts);
        return ts;
    }
}

