/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.fabric.jdbc;

import com.mysql.fabric.FabricCommunicationException;
import com.mysql.fabric.jdbc.FabricMySQLConnectionProxy;
import com.mysql.jdbc.Connection;
import com.mysql.jdbc.ConnectionImpl;
import com.mysql.jdbc.ExceptionInterceptor;
import com.mysql.jdbc.MySQLConnection;
import com.mysql.jdbc.SQLError;
import java.sql.SQLException;
import java.util.Properties;

public class ErrorReportingExceptionInterceptor
implements ExceptionInterceptor {
    private String hostname;
    private String port;
    private String fabricHaGroup;

    public SQLException interceptException(SQLException sqlEx, Connection conn) {
        MySQLConnection mysqlConn = (MySQLConnection)conn;
        if (ConnectionImpl.class.isAssignableFrom(mysqlConn.getLoadBalanceSafeProxy().getClass())) {
            return null;
        }
        FabricMySQLConnectionProxy fabricProxy = (FabricMySQLConnectionProxy)mysqlConn.getLoadBalanceSafeProxy();
        try {
            return fabricProxy.interceptException(sqlEx, conn, this.fabricHaGroup, this.hostname, this.port);
        }
        catch (FabricCommunicationException ex) {
            return SQLError.createSQLException("Failed to report error to Fabric.", "08S01", ex, conn.getExceptionInterceptor(), conn);
        }
    }

    public void init(Connection conn, Properties props2) throws SQLException {
        this.hostname = props2.getProperty("HOST");
        this.port = props2.getProperty("PORT");
        String connectionAttributes = props2.getProperty("connectionAttributes");
        this.fabricHaGroup = connectionAttributes.replaceAll("^.*\\bfabricHaGroup:(.+)\\b.*$", "$1");
    }

    public void destroy() {
    }
}

