/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.ExceptionInterceptor;
import com.mysql.jdbc.MysqlIO;
import com.mysql.jdbc.SQLError;
import com.mysql.jdbc.SocketFactory;
import com.mysql.jdbc.StringUtils;
import com.mysql.jdbc.util.Base64Decoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.security.KeyFactory;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.sql.SQLException;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class ExportControlled {
    private static final String SQL_STATE_BAD_SSL_PARAMS = "08000";

    protected static boolean enabled() {
        return true;
    }

    protected static void transformSocketToSSLSocket(MysqlIO mysqlIO) throws SQLException {
        StandardSSLSocketFactory sslFact = new StandardSSLSocketFactory(ExportControlled.getSSLSocketFactoryDefaultOrConfigured(mysqlIO), mysqlIO.socketFactory, mysqlIO.mysqlConnection);
        try {
            mysqlIO.mysqlConnection = sslFact.connect(mysqlIO.host, mysqlIO.port, null);
            ((SSLSocket)mysqlIO.mysqlConnection).setEnabledProtocols(new String[]{"TLSv1"});
            ((SSLSocket)mysqlIO.mysqlConnection).startHandshake();
            mysqlIO.mysqlInput = mysqlIO.connection.getUseUnbufferedInput() ? mysqlIO.mysqlConnection.getInputStream() : new BufferedInputStream(mysqlIO.mysqlConnection.getInputStream(), 16384);
            mysqlIO.mysqlOutput = new BufferedOutputStream(mysqlIO.mysqlConnection.getOutputStream(), 16384);
            mysqlIO.mysqlOutput.flush();
            mysqlIO.socketFactory = sslFact;
        }
        catch (IOException ioEx) {
            throw SQLError.createCommunicationsException(mysqlIO.connection, mysqlIO.getLastPacketSentTimeMs(), mysqlIO.getLastPacketReceivedTimeMs(), ioEx, mysqlIO.getExceptionInterceptor());
        }
    }

    private ExportControlled() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static SSLSocketFactory getSSLSocketFactoryDefaultOrConfigured(MysqlIO mysqlIO) throws SQLException {
        KeyManagerFactory kmf;
        TrustManagerFactory tmf;
        String clientCertificateKeyStoreUrl;
        block36: {
            char[] password;
            URL ksURL;
            InputStream ksIS;
            String trustCertificateKeyStorePassword;
            String trustCertificateKeyStoreType;
            String trustCertificateKeyStoreUrl;
            block35: {
                clientCertificateKeyStoreUrl = mysqlIO.connection.getClientCertificateKeyStoreUrl();
                trustCertificateKeyStoreUrl = mysqlIO.connection.getTrustCertificateKeyStoreUrl();
                String clientCertificateKeyStoreType = mysqlIO.connection.getClientCertificateKeyStoreType();
                String clientCertificateKeyStorePassword = mysqlIO.connection.getClientCertificateKeyStorePassword();
                trustCertificateKeyStoreType = mysqlIO.connection.getTrustCertificateKeyStoreType();
                trustCertificateKeyStorePassword = mysqlIO.connection.getTrustCertificateKeyStorePassword();
                if (StringUtils.isNullOrEmpty(clientCertificateKeyStoreUrl) && StringUtils.isNullOrEmpty(trustCertificateKeyStoreUrl) && mysqlIO.connection.getVerifyServerCertificate()) {
                    return (SSLSocketFactory)SSLSocketFactory.getDefault();
                }
                tmf = null;
                kmf = null;
                try {
                    tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                }
                catch (NoSuchAlgorithmException nsae) {
                    throw SQLError.createSQLException("Default algorithm definitions for TrustManager and/or KeyManager are invalid.  Check java security properties file.", SQL_STATE_BAD_SSL_PARAMS, 0, false, mysqlIO.getExceptionInterceptor());
                }
                if (!StringUtils.isNullOrEmpty(clientCertificateKeyStoreUrl)) {
                    ksIS = null;
                    try {
                        try {
                            if (!StringUtils.isNullOrEmpty(clientCertificateKeyStoreType)) {
                                KeyStore clientKeyStore = KeyStore.getInstance(clientCertificateKeyStoreType);
                                ksURL = new URL(clientCertificateKeyStoreUrl);
                                password = clientCertificateKeyStorePassword == null ? new char[]{} : clientCertificateKeyStorePassword.toCharArray();
                                ksIS = ksURL.openStream();
                                clientKeyStore.load(ksIS, password);
                                kmf.init(clientKeyStore, password);
                            }
                        }
                        catch (UnrecoverableKeyException uke) {
                            throw SQLError.createSQLException("Could not recover keys from client keystore.  Check password?", SQL_STATE_BAD_SSL_PARAMS, 0, false, mysqlIO.getExceptionInterceptor());
                        }
                        catch (NoSuchAlgorithmException nsae) {
                            throw SQLError.createSQLException("Unsupported keystore algorithm [" + nsae.getMessage() + "]", SQL_STATE_BAD_SSL_PARAMS, 0, false, mysqlIO.getExceptionInterceptor());
                        }
                        catch (KeyStoreException kse) {
                            throw SQLError.createSQLException("Could not create KeyStore instance [" + kse.getMessage() + "]", SQL_STATE_BAD_SSL_PARAMS, 0, false, mysqlIO.getExceptionInterceptor());
                        }
                        catch (CertificateException nsae) {
                            throw SQLError.createSQLException("Could not load client" + clientCertificateKeyStoreType + " keystore from " + clientCertificateKeyStoreUrl, mysqlIO.getExceptionInterceptor());
                        }
                        catch (MalformedURLException mue) {
                            throw SQLError.createSQLException(clientCertificateKeyStoreUrl + " does not appear to be a valid URL.", SQL_STATE_BAD_SSL_PARAMS, 0, false, mysqlIO.getExceptionInterceptor());
                        }
                        catch (IOException ioe) {
                            SQLException sqlEx = SQLError.createSQLException("Cannot open " + clientCertificateKeyStoreUrl + " [" + ioe.getMessage() + "]", SQL_STATE_BAD_SSL_PARAMS, 0, false, mysqlIO.getExceptionInterceptor());
                            sqlEx.initCause(ioe);
                            throw sqlEx;
                        }
                        Object var14_28 = null;
                        if (ksIS == null) break block35;
                    }
                    catch (Throwable throwable) {
                        Object var14_29 = null;
                        if (ksIS == null) throw throwable;
                        try {
                            ksIS.close();
                            throw throwable;
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {}
                    catch (IOException e2) {}
                    ksIS.close();
                }
            }
            if (!StringUtils.isNullOrEmpty(trustCertificateKeyStoreUrl)) {
                ksIS = null;
                try {
                    try {
                        if (!StringUtils.isNullOrEmpty(trustCertificateKeyStoreType)) {
                            KeyStore trustKeyStore = KeyStore.getInstance(trustCertificateKeyStoreType);
                            ksURL = new URL(trustCertificateKeyStoreUrl);
                            password = trustCertificateKeyStorePassword == null ? new char[]{} : trustCertificateKeyStorePassword.toCharArray();
                            ksIS = ksURL.openStream();
                            trustKeyStore.load(ksIS, password);
                            tmf.init(trustKeyStore);
                        }
                    }
                    catch (NoSuchAlgorithmException nsae) {
                        throw SQLError.createSQLException("Unsupported keystore algorithm [" + nsae.getMessage() + "]", SQL_STATE_BAD_SSL_PARAMS, 0, false, mysqlIO.getExceptionInterceptor());
                    }
                    catch (KeyStoreException kse) {
                        throw SQLError.createSQLException("Could not create KeyStore instance [" + kse.getMessage() + "]", SQL_STATE_BAD_SSL_PARAMS, 0, false, mysqlIO.getExceptionInterceptor());
                    }
                    catch (CertificateException nsae) {
                        throw SQLError.createSQLException("Could not load trust" + trustCertificateKeyStoreType + " keystore from " + trustCertificateKeyStoreUrl, SQL_STATE_BAD_SSL_PARAMS, 0, false, mysqlIO.getExceptionInterceptor());
                    }
                    catch (MalformedURLException mue) {
                        throw SQLError.createSQLException(trustCertificateKeyStoreUrl + " does not appear to be a valid URL.", SQL_STATE_BAD_SSL_PARAMS, 0, false, mysqlIO.getExceptionInterceptor());
                    }
                    catch (IOException ioe) {
                        SQLException sqlEx = SQLError.createSQLException("Cannot open " + trustCertificateKeyStoreUrl + " [" + ioe.getMessage() + "]", SQL_STATE_BAD_SSL_PARAMS, 0, false, mysqlIO.getExceptionInterceptor());
                        sqlEx.initCause(ioe);
                        throw sqlEx;
                    }
                    Object var17_33 = null;
                    if (ksIS == null) break block36;
                }
                catch (Throwable throwable) {
                    Object var17_34 = null;
                    if (ksIS == null) throw throwable;
                    try {
                        ksIS.close();
                        throw throwable;
                    }
                    catch (IOException e3) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (IOException e3) {}
                ksIS.close();
            }
        }
        SSLContext sslContext = null;
        try {
            TrustManager[] trustManagerArray;
            sslContext = SSLContext.getInstance("TLS");
            KeyManager[] keyManagerArray = StringUtils.isNullOrEmpty(clientCertificateKeyStoreUrl) ? null : kmf.getKeyManagers();
            if (mysqlIO.connection.getVerifyServerCertificate()) {
                trustManagerArray = tmf.getTrustManagers();
            } else {
                X509TrustManager[] x509TrustManagerArray = new X509TrustManager[1];
                trustManagerArray = x509TrustManagerArray;
                x509TrustManagerArray[0] = new X509TrustManager(){

                    public void checkClientTrusted(X509Certificate[] chain, String authType) {
                    }

                    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }
                };
            }
            sslContext.init(keyManagerArray, trustManagerArray, null);
            return sslContext.getSocketFactory();
        }
        catch (NoSuchAlgorithmException nsae) {
            throw SQLError.createSQLException("TLS is not a valid SSL protocol.", SQL_STATE_BAD_SSL_PARAMS, 0, false, mysqlIO.getExceptionInterceptor());
        }
        catch (KeyManagementException kme) {
            throw SQLError.createSQLException("KeyManagementException: " + kme.getMessage(), SQL_STATE_BAD_SSL_PARAMS, 0, false, mysqlIO.getExceptionInterceptor());
        }
    }

    public static boolean isSSLEstablished(MysqlIO mysqlIO) {
        return SSLSocket.class.isAssignableFrom(mysqlIO.mysqlConnection.getClass());
    }

    public static RSAPublicKey decodeRSAPublicKey(String key, ExceptionInterceptor interceptor) throws SQLException {
        try {
            if (key == null) {
                throw new SQLException("key parameter is null");
            }
            int offset = key.indexOf("\n") + 1;
            int len = key.indexOf("-----END PUBLIC KEY-----") - offset;
            byte[] certificateData = Base64Decoder.decode(key.getBytes(), offset, len);
            X509EncodedKeySpec spec = new X509EncodedKeySpec(certificateData);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            return (RSAPublicKey)kf.generatePublic(spec);
        }
        catch (Exception ex) {
            throw SQLError.createSQLException("Unable to decode public key", "S1009", ex, interceptor);
        }
    }

    public static byte[] encryptWithRSAPublicKey(byte[] source, RSAPublicKey key, ExceptionInterceptor interceptor) throws SQLException {
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA-1AndMGF1Padding");
            cipher.init(1, key);
            return cipher.doFinal(source);
        }
        catch (Exception ex) {
            throw SQLError.createSQLException(ex.getMessage(), "S1009", ex, interceptor);
        }
    }

    public static class StandardSSLSocketFactory
    implements SocketFactory {
        private SSLSocket rawSocket = null;
        private final SSLSocketFactory sslFact;
        private final SocketFactory existingSocketFactory;
        private final Socket existingSocket;

        public StandardSSLSocketFactory(SSLSocketFactory sslFact, SocketFactory existingSocketFactory, Socket existingSocket) {
            this.sslFact = sslFact;
            this.existingSocketFactory = existingSocketFactory;
            this.existingSocket = existingSocket;
        }

        public Socket afterHandshake() throws SocketException, IOException {
            this.existingSocketFactory.afterHandshake();
            return this.rawSocket;
        }

        public Socket beforeHandshake() throws SocketException, IOException {
            return this.rawSocket;
        }

        public Socket connect(String host, int portNumber, Properties props2) throws SocketException, IOException {
            this.rawSocket = (SSLSocket)this.sslFact.createSocket(this.existingSocket, host, portNumber, true);
            return this.rawSocket;
        }
    }
}

