/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.ExceptionInterceptor;
import com.mysql.jdbc.Messages;
import com.mysql.jdbc.MySQLConnection;
import com.mysql.jdbc.SQLError;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.TimeZone;

public class TimeUtil {
    static final TimeZone GMT_TIMEZONE = TimeZone.getTimeZone("GMT");
    private static final String TIME_ZONE_MAPPINGS_RESOURCE = "/com/mysql/jdbc/TimeZoneMapping.properties";
    static Properties timeZoneMappings = null;

    public static Time changeTimezone(MySQLConnection conn, Calendar sessionCalendar, Calendar targetCalendar, Time t2, TimeZone fromTz, TimeZone toTz, boolean rollForward) {
        if (conn != null) {
            if (conn.getUseTimezone() && !conn.getNoTimezoneConversionForTimeType()) {
                Calendar fromCal = Calendar.getInstance(fromTz);
                fromCal.setTime(t2);
                int fromOffset = fromCal.get(15) + fromCal.get(16);
                Calendar toCal = Calendar.getInstance(toTz);
                toCal.setTime(t2);
                int toOffset = toCal.get(15) + toCal.get(16);
                int offsetDiff = fromOffset - toOffset;
                long toTime = toCal.getTime().getTime();
                toTime = rollForward || conn.isServerTzUTC() && !conn.isClientTzUTC() ? (toTime += (long)offsetDiff) : (toTime -= (long)offsetDiff);
                Time changedTime = new Time(toTime);
                return changedTime;
            }
            if (conn.getUseJDBCCompliantTimezoneShift() && targetCalendar != null) {
                Time adjustedTime = new Time(TimeUtil.jdbcCompliantZoneShift(sessionCalendar, targetCalendar, t2));
                return adjustedTime;
            }
        }
        return t2;
    }

    public static Timestamp changeTimezone(MySQLConnection conn, Calendar sessionCalendar, Calendar targetCalendar, Timestamp tstamp, TimeZone fromTz, TimeZone toTz, boolean rollForward) {
        if (conn != null) {
            if (conn.getUseTimezone()) {
                Calendar fromCal = Calendar.getInstance(fromTz);
                fromCal.setTime(tstamp);
                int fromOffset = fromCal.get(15) + fromCal.get(16);
                Calendar toCal = Calendar.getInstance(toTz);
                toCal.setTime(tstamp);
                int toOffset = toCal.get(15) + toCal.get(16);
                int offsetDiff = fromOffset - toOffset;
                long toTime = toCal.getTime().getTime();
                toTime = rollForward || conn.isServerTzUTC() && !conn.isClientTzUTC() ? (toTime += (long)offsetDiff) : (toTime -= (long)offsetDiff);
                Timestamp changedTimestamp = new Timestamp(toTime);
                return changedTimestamp;
            }
            if (conn.getUseJDBCCompliantTimezoneShift() && targetCalendar != null) {
                Timestamp adjustedTimestamp = new Timestamp(TimeUtil.jdbcCompliantZoneShift(sessionCalendar, targetCalendar, tstamp));
                adjustedTimestamp.setNanos(tstamp.getNanos());
                return adjustedTimestamp;
            }
        }
        return tstamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long jdbcCompliantZoneShift(Calendar sessionCalendar, Calendar targetCalendar, Date dt) {
        if (sessionCalendar == null) {
            sessionCalendar = new GregorianCalendar();
        }
        Date origCalDate = targetCalendar.getTime();
        Date origSessionDate = sessionCalendar.getTime();
        try {
            sessionCalendar.setTime(dt);
            targetCalendar.set(1, sessionCalendar.get(1));
            targetCalendar.set(2, sessionCalendar.get(2));
            targetCalendar.set(5, sessionCalendar.get(5));
            targetCalendar.set(11, sessionCalendar.get(11));
            targetCalendar.set(12, sessionCalendar.get(12));
            targetCalendar.set(13, sessionCalendar.get(13));
            targetCalendar.set(14, sessionCalendar.get(14));
            long l2 = targetCalendar.getTime().getTime();
            Object var8_6 = null;
            sessionCalendar.setTime(origSessionDate);
            targetCalendar.setTime(origCalDate);
            return l2;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            sessionCalendar.setTime(origSessionDate);
            targetCalendar.setTime(origCalDate);
            throw throwable;
        }
    }

    static final java.sql.Date fastDateCreate(boolean useGmtConversion, Calendar gmtCalIfNeeded, Calendar cal, int year, int month, int day) {
        Calendar dateCal = cal;
        if (useGmtConversion) {
            if (gmtCalIfNeeded == null) {
                gmtCalIfNeeded = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            }
            gmtCalIfNeeded.clear();
            dateCal = gmtCalIfNeeded;
        }
        dateCal.clear();
        dateCal.set(14, 0);
        dateCal.set(year, month - 1, day, 0, 0, 0);
        long dateAsMillis = 0L;
        try {
            dateAsMillis = dateCal.getTimeInMillis();
        }
        catch (IllegalAccessError iae) {
            dateAsMillis = dateCal.getTime().getTime();
        }
        return new java.sql.Date(dateAsMillis);
    }

    static final java.sql.Date fastDateCreate(int year, int month, int day, Calendar targetCalendar) {
        Calendar dateCal = targetCalendar == null ? new GregorianCalendar() : targetCalendar;
        dateCal.clear();
        dateCal.set(year, month - 1, day, 0, 0, 0);
        dateCal.set(14, 0);
        long dateAsMillis = 0L;
        try {
            dateAsMillis = dateCal.getTimeInMillis();
        }
        catch (IllegalAccessError iae) {
            dateAsMillis = dateCal.getTime().getTime();
        }
        return new java.sql.Date(dateAsMillis);
    }

    static final Time fastTimeCreate(Calendar cal, int hour, int minute, int second, ExceptionInterceptor exceptionInterceptor) throws SQLException {
        if (hour < 0 || hour > 24) {
            throw SQLError.createSQLException("Illegal hour value '" + hour + "' for java.sql.Time type in value '" + TimeUtil.timeFormattedString(hour, minute, second) + ".", "S1009", exceptionInterceptor);
        }
        if (minute < 0 || minute > 59) {
            throw SQLError.createSQLException("Illegal minute value '" + minute + "' for java.sql.Time type in value '" + TimeUtil.timeFormattedString(hour, minute, second) + ".", "S1009", exceptionInterceptor);
        }
        if (second < 0 || second > 59) {
            throw SQLError.createSQLException("Illegal minute value '" + second + "' for java.sql.Time type in value '" + TimeUtil.timeFormattedString(hour, minute, second) + ".", "S1009", exceptionInterceptor);
        }
        cal.clear();
        cal.set(1970, 0, 1, hour, minute, second);
        long timeAsMillis = 0L;
        try {
            timeAsMillis = cal.getTimeInMillis();
        }
        catch (IllegalAccessError iae) {
            timeAsMillis = cal.getTime().getTime();
        }
        return new Time(timeAsMillis);
    }

    static final Time fastTimeCreate(int hour, int minute, int second, Calendar targetCalendar, ExceptionInterceptor exceptionInterceptor) throws SQLException {
        if (hour < 0 || hour > 23) {
            throw SQLError.createSQLException("Illegal hour value '" + hour + "' for java.sql.Time type in value '" + TimeUtil.timeFormattedString(hour, minute, second) + ".", "S1009", exceptionInterceptor);
        }
        if (minute < 0 || minute > 59) {
            throw SQLError.createSQLException("Illegal minute value '" + minute + "' for java.sql.Time type in value '" + TimeUtil.timeFormattedString(hour, minute, second) + ".", "S1009", exceptionInterceptor);
        }
        if (second < 0 || second > 59) {
            throw SQLError.createSQLException("Illegal minute value '" + second + "' for java.sql.Time type in value '" + TimeUtil.timeFormattedString(hour, minute, second) + ".", "S1009", exceptionInterceptor);
        }
        Calendar cal = targetCalendar == null ? new GregorianCalendar() : targetCalendar;
        cal.clear();
        cal.set(1970, 0, 1, hour, minute, second);
        long timeAsMillis = 0L;
        try {
            timeAsMillis = cal.getTimeInMillis();
        }
        catch (IllegalAccessError iae) {
            timeAsMillis = cal.getTime().getTime();
        }
        return new Time(timeAsMillis);
    }

    static final Timestamp fastTimestampCreate(boolean useGmtConversion, Calendar gmtCalIfNeeded, Calendar cal, int year, int month, int day, int hour, int minute, int seconds, int secondsPart) {
        cal.clear();
        cal.set(year, month - 1, day, hour, minute, seconds);
        int offsetDiff = 0;
        if (useGmtConversion) {
            int fromOffset = cal.get(15) + cal.get(16);
            if (gmtCalIfNeeded == null) {
                gmtCalIfNeeded = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            }
            gmtCalIfNeeded.clear();
            gmtCalIfNeeded.setTimeInMillis(cal.getTimeInMillis());
            int toOffset = gmtCalIfNeeded.get(15) + gmtCalIfNeeded.get(16);
            offsetDiff = fromOffset - toOffset;
        }
        if (secondsPart != 0) {
            cal.set(14, secondsPart / 1000000);
        }
        long tsAsMillis = 0L;
        try {
            tsAsMillis = cal.getTimeInMillis();
        }
        catch (IllegalAccessError iae) {
            tsAsMillis = cal.getTime().getTime();
        }
        Timestamp ts = new Timestamp(tsAsMillis + (long)offsetDiff);
        ts.setNanos(secondsPart);
        return ts;
    }

    static final Timestamp fastTimestampCreate(TimeZone tz, int year, int month, int day, int hour, int minute, int seconds, int secondsPart) {
        GregorianCalendar cal = tz == null ? new GregorianCalendar() : new GregorianCalendar(tz);
        cal.clear();
        cal.set(year, month - 1, day, hour, minute, seconds);
        long tsAsMillis = 0L;
        try {
            tsAsMillis = cal.getTimeInMillis();
        }
        catch (IllegalAccessError iae) {
            tsAsMillis = cal.getTime().getTime();
        }
        Timestamp ts = new Timestamp(tsAsMillis);
        ts.setNanos(secondsPart);
        return ts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCanonicalTimezone(String timezoneStr, ExceptionInterceptor exceptionInterceptor) throws SQLException {
        if (timezoneStr == null) {
            return null;
        }
        if ((timezoneStr = timezoneStr.trim()).length() > 2 && (timezoneStr.charAt(0) == '+' || timezoneStr.charAt(0) == '-') && Character.isDigit(timezoneStr.charAt(1))) {
            return "GMT" + timezoneStr;
        }
        Class<TimeUtil> clazz = TimeUtil.class;
        synchronized (TimeUtil.class) {
            if (timeZoneMappings == null) {
                TimeUtil.loadTimeZoneMappings(exceptionInterceptor);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            String canonicalTz = timeZoneMappings.getProperty(timezoneStr);
            if (canonicalTz != null) {
                return canonicalTz;
            }
            throw SQLError.createSQLException(Messages.getString("TimeUtil.UnrecognizedTimezoneId", new Object[]{timezoneStr}), "01S00", exceptionInterceptor);
        }
    }

    private static String timeFormattedString(int hours, int minutes, int seconds) {
        StringBuffer buf = new StringBuffer(8);
        if (hours < 10) {
            buf.append("0");
        }
        buf.append(hours);
        buf.append(":");
        if (minutes < 10) {
            buf.append("0");
        }
        buf.append(minutes);
        buf.append(":");
        if (seconds < 10) {
            buf.append("0");
        }
        buf.append(seconds);
        return buf.toString();
    }

    public static String formatNanos(int nanos, boolean serverSupportsFracSecs, boolean usingMicros) {
        if (nanos > 999999999) {
            nanos %= 100000000;
        }
        if (usingMicros) {
            nanos /= 1000;
        }
        if (!serverSupportsFracSecs || nanos == 0) {
            return "0";
        }
        int digitCount = usingMicros ? 6 : 9;
        String nanosString = Integer.toString(nanos);
        String zeroPadding = usingMicros ? "000000" : "000000000";
        nanosString = zeroPadding.substring(0, digitCount - nanosString.length()) + nanosString;
        int pos = digitCount - 1;
        while (nanosString.charAt(pos) == '0') {
            --pos;
        }
        nanosString = nanosString.substring(0, pos + 1);
        return nanosString;
    }

    private static void loadTimeZoneMappings(ExceptionInterceptor exceptionInterceptor) throws SQLException {
        timeZoneMappings = new Properties();
        try {
            timeZoneMappings.load(TimeZone.class.getResourceAsStream(TIME_ZONE_MAPPINGS_RESOURCE));
        }
        catch (IOException e2) {
            throw SQLError.createSQLException(Messages.getString("TimeUtil.LoadTimeZoneMappingError"), "01S00", exceptionInterceptor);
        }
        for (String tz : TimeZone.getAvailableIDs()) {
            if (timeZoneMappings.containsKey(tz)) continue;
            timeZoneMappings.put(tz, tz);
        }
    }
}

