/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import javax.sql.DataSource;
import org.apache.commons.dbutils.DbUtils;

public abstract class AbstractQueryRunner {
    private volatile boolean pmdKnownBroken = false;
    @Deprecated
    protected final DataSource ds;

    public AbstractQueryRunner() {
        this.ds = null;
    }

    public AbstractQueryRunner(boolean pmdKnownBroken) {
        this.pmdKnownBroken = pmdKnownBroken;
        this.ds = null;
    }

    public AbstractQueryRunner(DataSource ds) {
        this.ds = ds;
    }

    public AbstractQueryRunner(DataSource ds, boolean pmdKnownBroken) {
        this.pmdKnownBroken = pmdKnownBroken;
        this.ds = ds;
    }

    public DataSource getDataSource() {
        return this.ds;
    }

    public boolean isPmdKnownBroken() {
        return this.pmdKnownBroken;
    }

    protected PreparedStatement prepareStatement(Connection conn, String sql) throws SQLException {
        return conn.prepareStatement(sql);
    }

    protected Connection prepareConnection() throws SQLException {
        if (this.getDataSource() == null) {
            throw new SQLException("QueryRunner requires a DataSource to be invoked in this way, or a Connection should be passed in");
        }
        return this.getDataSource().getConnection();
    }

    public void fillStatement(PreparedStatement stmt, Object ... params) throws SQLException {
        ParameterMetaData pmd = null;
        if (!this.pmdKnownBroken) {
            int paramsCount;
            pmd = stmt.getParameterMetaData();
            int stmtCount = pmd.getParameterCount();
            int n2 = paramsCount = params == null ? 0 : params.length;
            if (stmtCount != paramsCount) {
                throw new SQLException("Wrong number of parameters: expected " + stmtCount + ", was given " + paramsCount);
            }
        }
        if (params == null) {
            return;
        }
        for (int i2 = 0; i2 < params.length; ++i2) {
            if (params[i2] != null) {
                stmt.setObject(i2 + 1, params[i2]);
                continue;
            }
            int sqlType = 12;
            if (!this.pmdKnownBroken) {
                try {
                    sqlType = pmd.getParameterType(i2 + 1);
                }
                catch (SQLException e2) {
                    this.pmdKnownBroken = true;
                }
            }
            stmt.setNull(i2 + 1, sqlType);
        }
    }

    public void fillStatementWithBean(PreparedStatement stmt, Object bean, PropertyDescriptor[] properties) throws SQLException {
        Object[] params = new Object[properties.length];
        for (int i2 = 0; i2 < properties.length; ++i2) {
            PropertyDescriptor property = properties[i2];
            Object value = null;
            Method method = property.getReadMethod();
            if (method == null) {
                throw new RuntimeException("No read method for bean property " + bean.getClass() + " " + property.getName());
            }
            try {
                value = method.invoke(bean, new Object[0]);
            }
            catch (InvocationTargetException e2) {
                throw new RuntimeException("Couldn't invoke method: " + method, e2);
            }
            catch (IllegalArgumentException e3) {
                throw new RuntimeException("Couldn't invoke method with 0 arguments: " + method, e3);
            }
            catch (IllegalAccessException e4) {
                throw new RuntimeException("Couldn't invoke method: " + method, e4);
            }
            params[i2] = value;
        }
        this.fillStatement(stmt, params);
    }

    public void fillStatementWithBean(PreparedStatement stmt, Object bean, String ... propertyNames) throws SQLException {
        PropertyDescriptor[] descriptors;
        try {
            descriptors = Introspector.getBeanInfo(bean.getClass()).getPropertyDescriptors();
        }
        catch (IntrospectionException e2) {
            throw new RuntimeException("Couldn't introspect bean " + bean.getClass().toString(), e2);
        }
        PropertyDescriptor[] sorted = new PropertyDescriptor[propertyNames.length];
        for (int i2 = 0; i2 < propertyNames.length; ++i2) {
            String propertyName = propertyNames[i2];
            if (propertyName == null) {
                throw new NullPointerException("propertyName can't be null: " + i2);
            }
            boolean found = false;
            for (int j2 = 0; j2 < descriptors.length; ++j2) {
                PropertyDescriptor descriptor = descriptors[j2];
                if (!propertyName.equals(descriptor.getName())) continue;
                sorted[i2] = descriptor;
                found = true;
                break;
            }
            if (found) continue;
            throw new RuntimeException("Couldn't find bean property: " + bean.getClass() + " " + propertyName);
        }
        this.fillStatementWithBean(stmt, bean, sorted);
    }

    protected void rethrow(SQLException cause, String sql, Object ... params) throws SQLException {
        String causeMessage = cause.getMessage();
        if (causeMessage == null) {
            causeMessage = "";
        }
        StringBuffer msg = new StringBuffer(causeMessage);
        msg.append(" Query: ");
        msg.append(sql);
        msg.append(" Parameters: ");
        if (params == null) {
            msg.append("[]");
        } else {
            msg.append(Arrays.deepToString(params));
        }
        SQLException e2 = new SQLException(msg.toString(), cause.getSQLState(), cause.getErrorCode());
        e2.setNextException(cause);
        throw e2;
    }

    protected ResultSet wrap(ResultSet rs) {
        return rs;
    }

    protected void close(Connection conn) throws SQLException {
        DbUtils.close(conn);
    }

    protected void close(Statement stmt) throws SQLException {
        DbUtils.close(stmt);
    }

    protected void close(ResultSet rs) throws SQLException {
        DbUtils.close(rs);
    }
}

