/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.sql.DataSource;
import org.apache.commons.dbutils.AbstractQueryRunner;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;

public class AsyncQueryRunner
extends AbstractQueryRunner {
    private final ExecutorService executorService;
    private final QueryRunner queryRunner;

    public AsyncQueryRunner(ExecutorService executorService, QueryRunner queryRunner) {
        this.executorService = executorService;
        this.queryRunner = queryRunner;
    }

    public AsyncQueryRunner(ExecutorService executorService) {
        this(null, false, executorService);
    }

    @Deprecated
    public AsyncQueryRunner(boolean pmdKnownBroken, ExecutorService executorService) {
        this(null, pmdKnownBroken, executorService);
    }

    @Deprecated
    public AsyncQueryRunner(DataSource ds, ExecutorService executorService) {
        this(ds, false, executorService);
    }

    @Deprecated
    public AsyncQueryRunner(DataSource ds, boolean pmdKnownBroken, ExecutorService executorService) {
        super(ds, pmdKnownBroken);
        this.executorService = executorService;
        this.queryRunner = new QueryRunner(ds, pmdKnownBroken);
    }

    public Future<int[]> batch(final Connection conn, final String sql, final Object[][] params) throws SQLException {
        return this.executorService.submit(new Callable<int[]>(){

            @Override
            public int[] call() throws Exception {
                return AsyncQueryRunner.this.queryRunner.batch(conn, sql, params);
            }
        });
    }

    public Future<int[]> batch(final String sql, final Object[][] params) throws SQLException {
        return this.executorService.submit(new Callable<int[]>(){

            @Override
            public int[] call() throws Exception {
                return AsyncQueryRunner.this.queryRunner.batch(sql, params);
            }
        });
    }

    public <T> Future<T> query(final Connection conn, final String sql, final ResultSetHandler<T> rsh, final Object ... params) throws SQLException {
        return this.executorService.submit(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return AsyncQueryRunner.this.queryRunner.query(conn, sql, rsh, params);
            }
        });
    }

    public <T> Future<T> query(final Connection conn, final String sql, final ResultSetHandler<T> rsh) throws SQLException {
        return this.executorService.submit(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return AsyncQueryRunner.this.queryRunner.query(conn, sql, rsh);
            }
        });
    }

    public <T> Future<T> query(final String sql, final ResultSetHandler<T> rsh, final Object ... params) throws SQLException {
        return this.executorService.submit(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return AsyncQueryRunner.this.queryRunner.query(sql, rsh, params);
            }
        });
    }

    public <T> Future<T> query(final String sql, final ResultSetHandler<T> rsh) throws SQLException {
        return this.executorService.submit(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return AsyncQueryRunner.this.queryRunner.query(sql, rsh);
            }
        });
    }

    public Future<Integer> update(final Connection conn, final String sql) throws SQLException {
        return this.executorService.submit(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return AsyncQueryRunner.this.queryRunner.update(conn, sql);
            }
        });
    }

    public Future<Integer> update(final Connection conn, final String sql, final Object param) throws SQLException {
        return this.executorService.submit(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return AsyncQueryRunner.this.queryRunner.update(conn, sql, param);
            }
        });
    }

    public Future<Integer> update(final Connection conn, final String sql, final Object ... params) throws SQLException {
        return this.executorService.submit(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return AsyncQueryRunner.this.queryRunner.update(conn, sql, params);
            }
        });
    }

    public Future<Integer> update(final String sql) throws SQLException {
        return this.executorService.submit(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return AsyncQueryRunner.this.queryRunner.update(sql);
            }
        });
    }

    public Future<Integer> update(final String sql, final Object param) throws SQLException {
        return this.executorService.submit(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return AsyncQueryRunner.this.queryRunner.update(sql, param);
            }
        });
    }

    public Future<Integer> update(final String sql, final Object ... params) throws SQLException {
        return this.executorService.submit(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return AsyncQueryRunner.this.queryRunner.update(sql, params);
            }
        });
    }

    @Deprecated
    protected class UpdateCallableStatement
    implements Callable<Integer> {
        private final String sql;
        private final Object[] params;
        private final Connection conn;
        private final boolean closeConn;
        private final PreparedStatement ps;

        public UpdateCallableStatement(Connection conn, boolean closeConn, PreparedStatement ps, String sql, Object ... params) {
            this.sql = sql;
            this.params = params;
            this.conn = conn;
            this.closeConn = closeConn;
            this.ps = ps;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Integer call() throws SQLException {
            int rows = 0;
            try {
                rows = this.ps.executeUpdate();
            }
            catch (SQLException e2) {
                AsyncQueryRunner.this.rethrow(e2, this.sql, this.params);
            }
            finally {
                AsyncQueryRunner.this.close(this.ps);
                if (this.closeConn) {
                    AsyncQueryRunner.this.close(this.conn);
                }
            }
            return rows;
        }
    }

    protected class QueryCallableStatement<T>
    implements Callable<T> {
        private final String sql;
        private final Object[] params;
        private final Connection conn;
        private final boolean closeConn;
        private final PreparedStatement ps;
        private final ResultSetHandler<T> rsh;

        public QueryCallableStatement(Connection conn, boolean closeConn, PreparedStatement ps, ResultSetHandler<T> rsh, String sql, Object ... params) {
            this.sql = sql;
            this.params = params;
            this.conn = conn;
            this.closeConn = closeConn;
            this.ps = ps;
            this.rsh = rsh;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T call() throws SQLException {
            ResultSet rs = null;
            T ret = null;
            try {
                rs = AsyncQueryRunner.this.wrap(this.ps.executeQuery());
                ret = this.rsh.handle(rs);
            }
            catch (SQLException e2) {
                AsyncQueryRunner.this.rethrow(e2, this.sql, this.params);
            }
            finally {
                try {
                    AsyncQueryRunner.this.close(rs);
                }
                finally {
                    AsyncQueryRunner.this.close(this.ps);
                    if (this.closeConn) {
                        AsyncQueryRunner.this.close(this.conn);
                    }
                }
            }
            return ret;
        }
    }

    @Deprecated
    protected class BatchCallableStatement
    implements Callable<int[]> {
        private final String sql;
        private final Object[][] params;
        private final Connection conn;
        private final boolean closeConn;
        private final PreparedStatement ps;

        public BatchCallableStatement(String sql, Object[][] params, Connection conn, boolean closeConn, PreparedStatement ps) {
            this.sql = sql;
            this.params = (Object[][])params.clone();
            this.conn = conn;
            this.closeConn = closeConn;
            this.ps = ps;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int[] call() throws SQLException {
            int[] ret = null;
            try {
                ret = this.ps.executeBatch();
            }
            catch (SQLException e2) {
                AsyncQueryRunner.this.rethrow(e2, this.sql, (Object[])this.params);
            }
            finally {
                AsyncQueryRunner.this.close(this.ps);
                if (this.closeConn) {
                    AsyncQueryRunner.this.close(this.conn);
                }
            }
            return ret;
        }
    }
}

